# ⚠️ Cloudflare Worker Setup Required

## You're seeing the error: "Server error: CDN_KEYS is not defined"

This means the Cloudflare Worker needs configuration before the CDN key registration can work.

---

## What You Need to Do

### Option 1: Use Existing 1CDN Service (Recommended)
If you're using the public 1CDN service at `1cdn.us`, contact the service administrator. They need to configure the Worker on their end.

### Option 2: Self-Hosted Setup (Advanced)
If you're running your own Cloudflare Worker, follow these steps:

---

## Quick Setup (5 Minutes)

### Step 1: Create KV Namespace in Cloudflare

1. Log into **Cloudflare Dashboard**
2. Go to **Workers & Pages** → **KV**
3. Click **Create namespace**
4. Name: `CDN_KEYS`
5. Click **Add**
6. Note the **Namespace ID** (you'll need this)

### Step 2: Bind KV to Your Worker

1. Go to **Workers & Pages** → **Overview**
2. Click on your **registration worker** (e.g., `cdn-registration-api`)
3. Click **Settings** tab
4. Click **Variables** section
5. Scroll to **KV Namespace Bindings**
6. Click **Add binding**
7. Fill in:
   - **Variable name**: `CDN_KEYS` ⚠️ Must be EXACTLY this
   - **KV namespace**: Select the `CDN_KEYS` namespace
8. Click **Save**
9. **Important**: Click **Deploy** to apply changes

### Step 3: Verify It Works

1. Return to WordPress Admin
2. CDN Manager → Settings → Security tab
3. Complete domain verification (any method)
4. Click **"Complete Registration & Get CDN Key"**
5. Should now work!

---

## Visual Guide

```
Cloudflare Dashboard
  │
  ├─→ Workers & Pages
  │     │
  │     ├─→ KV (Tab)
  │     │     └─→ Create namespace: "CDN_KEYS"
  │     │
  │     └─→ Overview
  │           └─→ Click your worker
  │                 └─→ Settings → Variables
  │                       └─→ KV Namespace Bindings
  │                             └─→ Add binding
  │                                   ├─ Variable name: CDN_KEYS
  │                                   └─ KV namespace: CDN_KEYS
```

---

## Common Mistakes

### ❌ Wrong Variable Name
```
Variable name: cdn_keys    ← Wrong (lowercase)
Variable name: CDN_Keys    ← Wrong (mixed case)
Variable name: CDN_KEYS    ← Correct!
```

### ❌ Forgot to Deploy
After adding the binding, you MUST click **Deploy** button!

### ❌ Wrong Worker
Make sure you're editing the **registration** worker, not the CDN validator or other workers.

---

## Need Help?

### For 1CDN Service Users:
Contact the 1CDN administrator at the domain where you signed up.

### For Self-Hosted Users:
1. Check `/app/cloudflare-deployment/CDN_KEYS-ERROR-FIX.md` for detailed troubleshooting
2. Check Cloudflare Worker logs for errors
3. Test with minimal worker code (see fix guide)

---

## What This KV Namespace Does

The `CDN_KEYS` namespace stores:
- Your domain name
- Your unique CDN key
- Registration timestamp
- Verification token

This allows the CDN to validate requests and serve your assets securely.

---

## Status Check

Before trying again, verify:
- [ ] KV namespace "CDN_KEYS" exists
- [ ] Worker has binding with variable name "CDN_KEYS"
- [ ] Worker has been deployed after adding binding
- [ ] No typos in binding name (case-sensitive!)

**Once configured, the registration will work immediately!**
