# Privacy Policy

## 1 CDN Manager
**Effective Date: 2025**

---

## Overview

Techtonic Systems Media and Research LLC ("we", "us", "our") respects your privacy. This Privacy Policy explains how 1 CDN Manager ("the Plugin") handles data.

---

## Data Collection

### What We DO NOT Collect:

- ❌ Personal information
- ❌ User behavior or analytics
- ❌ Website statistics
- ❌ IP addresses
- ❌ Email addresses
- ❌ Browsing history
- ❌ Any data transmitted to external servers

### What the Plugin Stores Locally:

- ✅ CDN configuration settings (stored in your WordPress database)
- ✅ Plugin preferences and options
- ✅ Cache files (stored on your server)

**All data stays on your server. Nothing is transmitted to us.**

---

## Third-Party Services

### CDN Providers

When you configure the Plugin to use CDN services:
- Your website assets (images, CSS, JS, etc.) are served through your CDN provider
- Your CDN provider may collect data according to their privacy policy
- We are not responsible for third-party privacy practices
- Review your CDN provider's privacy policy

### Cloudflare Integration (Optional)

If you use the optional Cloudflare integration:
- Your Cloudflare API credentials are stored locally in your WordPress database
- API calls are made directly from your server to Cloudflare
- No data is transmitted through our servers
- Review Cloudflare's privacy policy at: https://www.cloudflare.com/privacypolicy/

---

## Data Storage

### Local Storage Only
All plugin data is stored in:
- Your WordPress database (configuration settings)
- Your server's file system (cache files)
- No external databases or servers

### Data Retention
- Settings remain until you deactivate the plugin
- Cache files can be cleared at any time
- All data is removed if you uninstall the plugin

---

## Data Security

### Security Measures
- Settings stored using WordPress's secure options API
- No sensitive data transmitted externally
- API credentials stored locally (not transmitted to us)
- WordPress security best practices followed

### Your Responsibility
- Secure your WordPress installation
- Use strong passwords
- Keep WordPress and plugins updated
- Secure your CDN API credentials

---

## Cookies

The Plugin does not set any cookies.

---

## User Rights

Since we don't collect any personal data, there is no personal data to:
- Access
- Modify
- Delete
- Export

All plugin data is under your control on your server.

---

## GDPR Compliance

The Plugin is GDPR compliant because:
- No personal data is collected
- No data is transmitted to external servers
- No tracking or analytics
- All data remains on your server

---

## CCPA Compliance

The Plugin is CCPA compliant because:
- No personal information is collected
- No data is sold to third parties
- No consumer data is processed

---

## Children's Privacy

The Plugin does not collect data from anyone, including children under 13.

---

## Changes to This Privacy Policy

We may update this Privacy Policy from time to time. We will notify users of any material changes by:
- Updating this document
- Updating the "Last Updated" date
- Posting notice on the plugin page

---

## WordPress.org

This plugin is distributed via WordPress.org. WordPress.org has its own privacy policy:
https://wordpress.org/about/privacy/

---

## Contact Us

If you have questions about this Privacy Policy:

**Techtonic Systems Media and Research LLC**  
Website: https://techtonic.systems  
Plugin Support: WordPress.org support forums

---

## Summary

**In Plain English:**

We don't collect, store, or transmit any of your data. The plugin works entirely on your server. Your CDN configuration stays in your WordPress database. We can't see it, access it, or collect it. Your privacy is completely protected.

---

*Last Updated: 2025*  
*Plugin: 1 CDN Manager v1.0.0*  
*Company: Techtonic Systems Media and Research LLC*