# 1 CDN Manager

**Version:** 1.0.4  
**Author:** Techtonic Systems Media and Research LLC  
**License:** GPLv2 or later  
**Requires WordPress:** 5.0 or higher  
**Requires PHP:** 7.4 or higher

---

## Description

Professional WordPress CDN plugin with multi-domain support, Cloudflare integration, auto-updates, and advanced caching capabilities.

### Key Features

- **5 CDN Types Support**: Image, Media, Static (CSS/JS), Fonts, and Frontend URL
- **Smart URL Rewriting**: Automatic detection and replacement of asset URLs
- **CORS Support**: Built-in Cross-Origin Resource Sharing handling
- **Advanced Caching**: Intelligent cache system with automatic optimization
- **Content Migration Tools**: Migrate existing URLs to CDN permanently
- **Conflict Detection**: Automatically detects conflicting CDN plugins
- **Cloudflare Integration**: Optional direct cache management and purging
- **Multi-Domain Support**: Different CDN URLs for different asset types

---

## Installation

### Method 1: WordPress.org (Recommended)

1. Go to WordPress Admin → Plugins → Add New
2. Search for "1 CDN Manager"
3. Click "Install Now" and then "Activate"
4. Configure CDN settings at **1 CDN Manager → Settings**

### Method 2: Manual Installation

1. Download plugin from WordPress.org or [https://wp-cdn-manager.1cdn.us/](https://wp-cdn-manager.1cdn.us/)
2. Go to WordPress Admin → Plugins → Add New → Upload Plugin
3. Select the zip file and click "Install Now"
4. Activate "1 CDN Manager"
5. Configure CDN settings at **1 CDN Manager → Settings**

### Method 3: WP-CLI

```bash
wp plugin install 1-cdn-manager --activate
```

---

## Configuration

### Basic Setup

1. Go to **CDN Manager → Settings**
2. Enable CDN features
3. Enter your CDN URLs:
   - **CDN Domain**: Your main CDN URL
   - **Origin Domain**: Your origin server URL
   - **Image CDN**: Separate URL for images (optional)
   - **Static CDN**: Separate URL for CSS/JS (optional)
4. Save settings
5. Test your website

### Cloudflare Integration (Optional)

1. Go to **CDN Manager → Cloudflare**
2. Enter your:
   - **Zone ID** (from Cloudflare Dashboard)
   - **API Token** (create at Cloudflare → My Profile → API Tokens)
3. Click "Test Connection" to verify
4. Use cache management features:
   - Purge all cache
   - Purge specific URLs
   - Purge by wildcard
   - Toggle developer mode
   - Configure cache TTL

---

## Features in Detail

### Multi-Domain CDN

Configure separate CDN domains for different asset types:

```
Main Site: https://example.com
CDN Domain: https://cdn.example.com
Image CDN: https://img.example.com
Static CDN: https://static.example.com
```

### Cloudflare Cache Management

- **Purge All**: Clear all cached content
- **Selective Purge**: Purge specific URLs
- **Wildcard Purge**: Purge by prefix (e.g., `/uploads/*`)
- **Developer Mode**: Bypass cache temporarily
- **Always Online**: Serve cached pages when origin is down
- **Cache TTL**: Configure browser cache duration

### Auto-Updates

Plugin automatically checks for updates from our S3 repository. Updates are shown in WordPress admin like any other plugin.

### Conflict Detection

Automatically detects conflicting CDN plugins:
- Jetpack Photon
- WP Rocket
- W3 Total Cache
- And more...

---

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- MySQL 5.6 or higher
- mod_rewrite enabled (for .htaccess)
- HTTPS recommended

### Optional

- Cloudflare account (for Cloudflare features)
- CDN provider (Cloudflare, AWS CloudFront, etc.)

---

## Frequently Asked Questions

### Is this plugin free?

Yes, for **personal, non-commercial use**. Commercial use requires a separate license.

### Do you collect any data?

No. We do **NOT** collect any data. Everything stays on your server. See [PRIVACY-POLICY.md](PRIVACY-POLICY.md) for details.

### Is this open source?

No. This is proprietary software. See [LICENSE.md](LICENSE.md) for details.

### Can I modify the plugin?

No. Modification, reverse engineering, and redistribution are not allowed. See [NDA.md](NDA.md) for details.

### Do I need Cloudflare?

No. Cloudflare integration is optional. The plugin works with any CDN provider.

### How do I get support?

Email: support@utility-server.com  
Website: https://www.utility-server.com

---

## Legal Documents

Please read these important documents:

- **[TERMS-AND-CONDITIONS.md](TERMS-AND-CONDITIONS.md)** - User agreement
- **[LICENSE.md](LICENSE.md)** - Proprietary license agreement
- **[PRIVACY-POLICY.md](PRIVACY-POLICY.md)** - Zero data collection policy
- **[DISCLAIMER.md](DISCLAIMER.md)** - Legal disclaimer and liability
- **[NDA.md](NDA.md)** - Non-disclosure agreement

**By using this plugin, you agree to all the above documents.**

---

## Changelog

### Version 1.0.5 - October 12, 2025

**Added:**
- Complete Cloudflare integration
- Cache purge (all, selective, wildcard)
- Developer mode toggle
- Always online toggle
- Browser cache TTL configuration
- New Cloudflare admin tab

**Updated:**
- Branding to DNS Stack Private Limited
- Legal documents in markdown format
- Dynamic version display

**Improved:**
- Better cache management workflow
- Cleaner admin interface

### Version 1.0.4 - October 12, 2025

- Professional S3 landing page
- Enhanced knowledge base
- Better documentation

### Version 1.0.3 - October 12, 2025

- AJAX-based manual update check
- Fixed branding header gradient
- Enhanced logo display

### Version 1.0.2 - October 12, 2025

- Manual update check button
- Professional branding with logos
- Auto-update system

### Version 1.0.1 Beta - October 12, 2025

- Fixed font 404 errors
- Fixed CORS support
- Fixed image routing
- Added conflict detection

### Version 1.0.0 Beta - January 1, 2025

- Initial release

---

## Support

- **Email**: support@utility-server.com
- **Website**: https://www.utility-server.com
- **Documentation**: https://wp-cdn-manager.utility-server.com

---

## Credits

Developed by **DNS Stack Private Limited**  
Powered by **Utility Server** Technology  
Supported by **RHINO** and **MARLIN** Infrastructure

---

## License

Proprietary Software - Personal Non-Commercial Use Only

See [LICENSE.md](LICENSE.md) for complete terms.

---

© 2025 DNS Stack Private Limited (Utility Server). All rights reserved.
