<?php
if (!defined('ABSPATH')) exit;

$current_url = home_url();
$origin_url = CDN1_Settings::get('origin_url', '');
$is_default_cdn = CDN1_Settings::is_default_cdn_enabled();
$suggestions = CDN1_Migrator::get_suggested_migrations();
?>

<div class="wrap cdn1-migration">
    <?php include CDN1_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <?php if ($is_default_cdn): ?>
    <!-- Default CDN Notice -->
    <div class="notice notice-warning" style="padding: 20px; margin-top: 20px; border-left: 4px solid #ff9800;">
        <h2 style="margin-top: 0;">⚠️ <?php esc_html_e('Content Migration Not Available with Default CDN', '1cdn-manager'); ?></h2>
        <p style="font-size: 14px;">
            <?php esc_html_e('Database migration is only available when using Custom CDN configuration. Default CDN handles URL rewriting automatically on-the-fly, so database migration is not needed.', '1cdn-manager'); ?>
        </p>
        <p style="font-size: 14px; margin-bottom: 0;">
            <strong><?php esc_html_e('To use database migration features:', '1cdn-manager'); ?></strong>
        </p>
        <ol style="margin-left: 20px;">
            <li><?php esc_html_e('Go to CDN Manager → Settings', '1cdn-manager'); ?></li>
            <li><?php esc_html_e('Disable Default CDN', '1cdn-manager'); ?></li>
            <li><?php esc_html_e('Configure Custom CDN with your own domains', '1cdn-manager'); ?></li>
            <li><?php esc_html_e('Return here to migrate your database content', '1cdn-manager'); ?></li>
        </ol>
        <p style="margin-top: 15px;">
            <a href="<?php echo esc_url(admin_url('admin.php?page=cdn1-settings')); ?>" class="button button-primary">
                <?php esc_html_e('Go to CDN Settings →', '1cdn-manager'); ?>
            </a>
        </p>
    </div>
    
    <div style="opacity: 0.5; pointer-events: none;">
    <?php endif; ?>
    
    <p class="description">
        <?php esc_html_e('Permanently update URLs in your database content for Image CDN, Media CDN, CSS CDN, JavaScript CDN, Fonts CDN, and Frontend URL replacements.', '1cdn-manager'); ?>
    </p>
    
    <!-- Info Notice -->
    <div class="notice notice-info inline">
        <p>
            <strong>💡 <?php esc_html_e('Two Options Available:', '1cdn-manager'); ?></strong><br>
            <strong><?php esc_html_e('Database Migration (This Page):', '1cdn-manager'); ?></strong> <?php esc_html_e('Permanently updates URLs in database. Better for SEO and performance.', '1cdn-manager'); ?><br>
            <strong><?php esc_html_e('On-the-Fly Rewriting:', '1cdn-manager'); ?></strong> <?php esc_html_e('Replaces URLs dynamically without touching database. Go to CDN Manager → Settings → Content Rewriting.', '1cdn-manager'); ?>
        </p>
    </div>
    
    <!-- Warning Notice -->
    <div class="notice notice-warning inline">
        <p>
            <strong>⚠️ <?php esc_html_e('Important:', '1cdn-manager'); ?></strong> 
            <?php esc_html_e('Always backup your database before running a migration. This operation will modify your content permanently.', '1cdn-manager'); ?>
        </p>
    </div>
    
    <!-- Current Configuration -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Current Configuration', '1cdn-manager'); ?></h2>
        
        <table class="widefat">
            <tbody>
                <tr>
                    <td><strong><?php esc_html_e('Current Site URL', '1cdn-manager'); ?></strong></td>
                    <td><code><?php echo esc_html($current_url); ?></code></td>
                </tr>
                <?php if ($origin_url): ?>
                <tr>
                    <td><strong><?php esc_html_e('Origin URL', '1cdn-manager'); ?></strong></td>
                    <td><code><?php echo esc_html($origin_url); ?></code></td>
                </tr>
                <?php endif; ?>
                
                <?php if ($is_default_cdn): ?>
                <!-- Show Default CDN Status -->
                <tr style="background: #e7f5ff;">
                    <td colspan="2"><strong style="color: #1565c0;">⚡ <?php esc_html_e('Default CDN Enabled (1cdn.us)', '1cdn-manager'); ?></strong></td>
                </tr>
                <?php
                $default_cdn_types = [
                    'js' => ['label' => 'JavaScript', 'subdomain' => 'js.1cdn.us', 'enable' => 'enable_default_cdn_js'],
                    'css' => ['label' => 'CSS', 'subdomain' => 'cs.1cdn.us', 'enable' => 'enable_default_cdn_css'],
                    'image' => ['label' => 'Images', 'subdomain' => 'im.1cdn.us', 'enable' => 'enable_default_cdn_images'],
                    'fonts' => ['label' => 'Fonts', 'subdomain' => 'ft.1cdn.us', 'enable' => 'enable_default_cdn_fonts'],
                    'media' => ['label' => 'Media', 'subdomain' => 'mi.1cdn.us', 'enable' => 'enable_default_cdn_media'],
                ];
                
                foreach ($default_cdn_types as $key => $cdn) {
                    $enabled = CDN1_Settings::get($cdn['enable'], 0);
                    echo '<tr>';
                    echo '<td><strong>' . esc_html($cdn['label']) . ' (Default CDN)</strong></td>';
                    echo '<td>';
                    if ($enabled) {
                        echo '<code>' . esc_html($cdn['subdomain']) . '</code> <span style="color: #00a32a;">✓ Enabled</span>';
                    } else {
                        echo '<span style="color: #999;">Not enabled</span>';
                    }
                    echo '</td>';
                    echo '</tr>';
                }
                ?>
                <?php else: ?>
                <!-- Show Custom CDN Status -->
                <tr>
                    <td><strong><?php esc_html_e('Image CDN', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_image_cdn')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_image_base')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Media CDN', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_media_cdn')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_media_base')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('CSS CDN', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_css_cdn')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_css_base')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('JavaScript CDN', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_js_cdn')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_js_base')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Fonts CDN', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_fonts_cdn')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_fonts_base')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Frontend URL', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if (CDN1_Settings::get('enable_frontend_url')): ?>
                            <code><?php echo esc_html(CDN1_Settings::get('cdn_frontend_url')); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Suggested Migrations -->
    <?php if (!empty($suggestions)): ?>
    <div class="cdn1-section">
        <h2><?php esc_html_e('Suggested Migrations', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Based on your current configuration, here are recommended URL migrations:', '1cdn-manager'); ?></p>
        
        <div class="cdn1-suggestions">
            <?php foreach ($suggestions as $index => $suggestion): ?>
            <div class="cdn1-suggestion-card" style="background: #f6f7f7; padding: 15px; margin-bottom: 15px; border-radius: 4px;">
                <h3 style="margin-top: 0;"><?php echo esc_html($suggestion['description']); ?></h3>
                <p style="margin: 10px 0;">
                    <strong><?php esc_html_e('From:', '1cdn-manager'); ?></strong> <code><?php echo esc_html($suggestion['from']); ?></code><br>
                    <strong><?php esc_html_e('To:', '1cdn-manager'); ?></strong> <code><?php echo esc_html($suggestion['to']); ?></code>
                </p>
                <button type="button" class="button button-secondary cdn1-use-suggestion" 
                        data-from="<?php echo esc_attr($suggestion['from']); ?>"
                        data-to="<?php echo esc_attr($suggestion['to']); ?>">
                    <?php esc_html_e('Use This Migration', '1cdn-manager'); ?>
                </button>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Custom Migration Tool -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Custom URL Migration', '1cdn-manager'); ?></h2>
        
        <form id="cdn1-migration-form" style="max-width: 800px;">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="old_url"><?php esc_html_e('Find URL', '1cdn-manager'); ?></label>
                    </th>
                    <td>
                        <input type="url" id="old_url" name="old_url" 
                               class="regular-text" 
                               placeholder="https://example.com"
                               value="<?php echo esc_attr($current_url); ?>">
                        <p class="description">
                            <?php esc_html_e('The URL to search for in your database content.', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="new_url"><?php esc_html_e('Replace With', '1cdn-manager'); ?></label>
                    </th>
                    <td>
                        <input type="url" id="new_url" name="new_url" 
                               class="regular-text" 
                               placeholder="https://cdn.example.com"
                               value="<?php echo esc_attr($origin_url ? $origin_url : ''); ?>">
                        <p class="description">
                            <?php esc_html_e('The new URL that will replace the old one.', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
            </table>
            
            <div class="cdn1-actions">
                <button type="button" id="cdn1-scan-btn" class="button button-large">
                    <span class="dashicons dashicons-search"></span>
                    <?php esc_html_e('Scan Database', '1cdn-manager'); ?>
                </button>
                
                <button type="button" id="cdn1-dry-run-btn" class="button button-large" style="margin-left: 10px;">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('Preview Migration', '1cdn-manager'); ?>
                </button>
                
                <button type="button" id="cdn1-migrate-btn" class="button button-primary button-large" style="margin-left: 10px;" disabled>
                    <span class="dashicons dashicons-database-import"></span>
                    <?php esc_html_e('Run Migration', '1cdn-manager'); ?>
                </button>
            </div>
        </form>
        
        <!-- Results Display -->
        <div id="cdn1-migration-results" style="margin-top: 30px; display: none;">
            <h3><?php esc_html_e('Migration Results', '1cdn-manager'); ?></h3>
            <div id="cdn1-results-content"></div>
        </div>
    </div>
    
    <!-- Migration Info -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('What Gets Migrated?', '1cdn-manager'); ?></h2>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
            <div style="background: #f6f7f7; padding: 15px; border-radius: 4px;">
                <h4 style="margin-top: 0;">
                    <span class="dashicons dashicons-media-document"></span>
                    <?php esc_html_e('Posts & Pages', '1cdn-manager'); ?>
                </h4>
                <p style="margin-bottom: 0;">
                    <?php esc_html_e('Content and excerpts in all posts, pages, and custom post types.', '1cdn-manager'); ?>
                </p>
            </div>
            
            <div style="background: #f6f7f7; padding: 15px; border-radius: 4px;">
                <h4 style="margin-top: 0;">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <?php esc_html_e('Custom Fields', '1cdn-manager'); ?>
                </h4>
                <p style="margin-bottom: 0;">
                    <?php esc_html_e('All post meta and custom field values (ACF, etc.).', '1cdn-manager'); ?>
                </p>
            </div>
            
            <div style="background: #f6f7f7; padding: 15px; border-radius: 4px;">
                <h4 style="margin-top: 0;">
                    <span class="dashicons dashicons-admin-comments"></span>
                    <?php esc_html_e('Comments', '1cdn-manager'); ?>
                </h4>
                <p style="margin-bottom: 0;">
                    <?php esc_html_e('Comment content and author URLs.', '1cdn-manager'); ?>
                </p>
            </div>
            
            <div style="background: #f6f7f7; padding: 15px; border-radius: 4px;">
                <h4 style="margin-top: 0;">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <?php esc_html_e('Options', '1cdn-manager'); ?>
                </h4>
                <p style="margin-bottom: 0;">
                    <?php esc_html_e('WordPress options and settings (excluding transients).', '1cdn-manager'); ?>
                </p>
            </div>
        </div>
    </div>
    
    <!-- Safety Tips -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Safety Tips', '1cdn-manager'); ?></h2>
        
        <div class="cdn1-tips">
            <div class="cdn1-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><strong><?php esc_html_e('Always backup first:', '1cdn-manager'); ?></strong> <?php esc_html_e('Use your hosting control panel or a backup plugin to create a full database backup.', '1cdn-manager'); ?></p>
            </div>
            <div class="cdn1-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><strong><?php esc_html_e('Test on staging:', '1cdn-manager'); ?></strong> <?php esc_html_e('If possible, test the migration on a staging site before running on production.', '1cdn-manager'); ?></p>
            </div>
            <div class="cdn1-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><strong><?php esc_html_e('Use preview first:', '1cdn-manager'); ?></strong> <?php esc_html_e('Click "Preview Migration" to see how many items will be affected before running the actual migration.', '1cdn-manager'); ?></p>
            </div>
            <div class="cdn1-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><strong><?php esc_html_e('Be specific:', '1cdn-manager'); ?></strong> <?php esc_html_e('Use complete URLs including https:// to avoid unintended replacements.', '1cdn-manager'); ?></p>
            </div>
        </div>
    </div>
    
    <?php if ($is_default_cdn): ?>
    </div><!-- End disabled wrapper for Default CDN -->
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    // Use suggestion button
    $('.cdn1-use-suggestion').on('click', function() {
        const from = $(this).data('from');
        const to = $(this).data('to');
        $('#old_url').val(from);
        $('#new_url').val(to);
        $('html, body').animate({
            scrollTop: $('#cdn1-migration-form').offset().top - 100
        }, 500);
    });
    
    // Scan database
    $('#cdn1-scan-btn').on('click', function() {
        const $btn = $(this);
        const oldUrl = $('#old_url').val();
        const newUrl = $('#new_url').val();
        
        if (!oldUrl || !newUrl) {
            alert('<?php esc_html_e('Please enter both URLs', '1cdn-manager'); ?>');
            return;
        }
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update dashicons-spin"></span> <?php esc_html_e('Scanning...', '1cdn-manager'); ?>');
        
        $.post(ajaxurl, {
            action: 'cdn1_scan_content',
            nonce: '<?php echo esc_js(wp_create_nonce('cdn1_admin')); ?>',
            old_url: oldUrl,
            new_url: newUrl
        }, function(response) {
            if (response.success) {
                displayResults(response.data, true);
                $('#cdn1-migrate-btn').prop('disabled', false);
            } else {
                alert('<?php esc_html_e('Error:', '1cdn-manager'); ?> ' + response.data.message);
            }
        }).always(function() {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-search"></span> <?php esc_html_e('Scan Database', '1cdn-manager'); ?>');
        });
    });
    
    // Preview migration (dry run)
    $('#cdn1-dry-run-btn').on('click', function() {
        const $btn = $(this);
        const oldUrl = $('#old_url').val();
        const newUrl = $('#new_url').val();
        
        if (!oldUrl || !newUrl) {
            alert('<?php esc_html_e('Please enter both URLs', '1cdn-manager'); ?>');
            return;
        }
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update dashicons-spin"></span> <?php esc_html_e('Previewing...', '1cdn-manager'); ?>');
        
        $.post(ajaxurl, {
            action: 'cdn1_migrate_content',
            nonce: '<?php echo esc_js(wp_create_nonce('cdn1_admin')); ?>',
            old_url: oldUrl,
            new_url: newUrl,
            dry_run: 'true'
        }, function(response) {
            if (response.success) {
                displayResults(response.data, true);
                $('#cdn1-migrate-btn').prop('disabled', false);
            } else {
                alert('<?php esc_html_e('Error:', '1cdn-manager'); ?> ' + response.data.message);
            }
        }).always(function() {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-visibility"></span> <?php esc_html_e('Preview Migration', '1cdn-manager'); ?>');
        });
    });
    
    // Run migration
    $('#cdn1-migrate-btn').on('click', function() {
        const $btn = $(this);
        const oldUrl = $('#old_url').val();
        const newUrl = $('#new_url').val();
        
        if (!confirm('<?php esc_html_e('Are you sure you want to run this migration? This will permanently modify your database. Make sure you have a backup!', '1cdn-manager'); ?>')) {
            return;
        }
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update dashicons-spin"></span> <?php esc_html_e('Migrating...', '1cdn-manager'); ?>');
        
        $.post(ajaxurl, {
            action: 'cdn1_migrate_content',
            nonce: '<?php echo esc_js(wp_create_nonce('cdn1_admin')); ?>',
            old_url: oldUrl,
            new_url: newUrl,
            dry_run: 'false'
        }, function(response) {
            if (response.success) {
                displayResults(response.data, false);
                alert('<?php esc_html_e('Migration completed successfully!', '1cdn-manager'); ?>');
            } else {
                alert('<?php esc_html_e('Error:', '1cdn-manager'); ?> ' + response.data.message);
            }
        }).always(function() {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-database-import"></span> <?php esc_html_e('Run Migration', '1cdn-manager'); ?>');
        });
    });
    
    function displayResults(data, isPreview) {
        const mode = isPreview ? '<?php esc_html_e('Preview Mode', '1cdn-manager'); ?>' : '<?php esc_html_e('Migration Complete', '1cdn-manager'); ?>';
        const html = `
            <div class="notice notice-${isPreview ? 'info' : 'success'} inline">
                <p><strong>${mode}</strong></p>
            </div>
            <table class="widefat">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Content Type', '1cdn-manager'); ?></th>
                        <th style="text-align: right;"><?php esc_html_e('Items Affected', '1cdn-manager'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php esc_html_e('Posts & Pages', '1cdn-manager'); ?></td>
                        <td style="text-align: right;"><strong>${data.posts}</strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Custom Fields (Post Meta)', '1cdn-manager'); ?></td>
                        <td style="text-align: right;"><strong>${data.postmeta}</strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Options', '1cdn-manager'); ?></td>
                        <td style="text-align: right;"><strong>${data.options}</strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Comments', '1cdn-manager'); ?></td>
                        <td style="text-align: right;"><strong>${data.comments}</strong></td>
                    </tr>
                    <tr style="background: #f6f7f7;">
                        <td><strong><?php esc_html_e('Total', '1cdn-manager'); ?></strong></td>
                        <td style="text-align: right;"><strong style="font-size: 16px;">${data.total}</strong></td>
                    </tr>
                </tbody>
            </table>
        `;
        
        $('#cdn1-results-content').html(html);
        $('#cdn1-migration-results').slideDown();
    }
});
</script>
