<?php
if (!defined('ABSPATH')) exit;
?>

<style>
/* Hide WordPress admin notices on Pro Solution page - this is a showcase/info page */
.cdn1-pro-solution .notice,
.cdn1-pro-solution .updated,
.cdn1-pro-solution .error,
.wrap.cdn1-pro-solution + .notice,
.wrap.cdn1-pro-solution + .updated,
.wrap.cdn1-pro-solution + .error {
    display: none !important;
}
/* Also hide notices that WordPress injects before wrap */
body.wp-admin .cdn1-pro-solution ~ .notice,
#wpbody-content > .notice {
    display: none !important;
}
</style>

<div class="wrap cdn1-settings cdn1-pro-solution">
    <?php include CDN1_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <!-- Hero Section -->
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 60px 40px; border-radius: 12px; margin: 20px 0 30px 0; text-align: center; color: white; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">
        <div style="max-width: 900px; margin: 0 auto;">
            <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-utility-server.png'); ?>" 
                 alt="Utility Server" 
                 style="height: 120px; width: auto; margin-bottom: 30px; filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));">
            
            <h1 style="font-size: 42px; margin: 0 0 20px 0; font-weight: 700; text-shadow: 0 2px 4px rgba(0,0,0,0.3);">
                Unlock the Power of Utility Server
            </h1>
            
            <!-- Integration Notice (Below Header) -->
            <div style="background: rgba(16, 185, 129, 0.2); border: 2px solid rgba(255, 255, 255, 0.5); padding: 15px 30px; border-radius: 8px; margin: 20px auto 30px auto; max-width: 700px; backdrop-filter: blur(10px); text-align: center;">
                <p style="margin: 0; font-size: 16px; font-weight: 600; color: white; text-align: center;">
                    <span style="font-size: 20px; margin-right: 8px;">⚡</span>
                    <strong>One-Click Integration of Utility Server modules</strong> is on the way!
                </p>
                <p style="margin: 8px 0 0 0; font-size: 14px; opacity: 0.95; color: white; text-align: center;">
                    Seamless activation coming soon.
                </p>
            </div>
            
            <p style="font-size: 20px; margin: 20px 0 30px 0; opacity: 0.95; line-height: 1.6; text-shadow: 0 1px 2px rgba(0,0,0,0.2);">
                Supercharge your website with AI-powered optimization, intelligent image delivery, and lightning-fast edge caching.
            </p>
            
            <p style="font-size: 16px; margin: 0; opacity: 0.9; font-weight: 500;">
                Three powerful modules. One seamless platform. Unlimited performance potential.
            </p>
        </div>
    </div>
    
    <!-- Company Selection Section -->
    <div style="background: #f8f9fa; padding: 40px; border-radius: 12px; margin: 40px 0; border: 2px solid #e9ecef;">
        <h2 style="text-align: center; font-size: 32px; margin: 0 0 15px 0; color: #2c3e50;">
            Choose Your Provider
        </h2>
        <p style="text-align: center; font-size: 16px; color: #6c757d; margin: 0 0 40px 0;">
            Get Utility Server from your preferred provider - same powerful features, your choice of partner.
        </p>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; max-width: 900px; margin: 0 auto;">
            <!-- DNS Stack Card -->
            <div style="background: white; border: 2px solid #667eea; border-radius: 12px; padding: 40px; text-align: center; transition: all 0.3s ease; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
                <div style="width: 100px; height: 100px; margin: 0 auto 20px;">
                    <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-dnsstack.png'); ?>" 
                         alt="DNS Stack" 
                         style="width: 100%; height: 100%; object-fit: contain; filter: drop-shadow(0 2px 8px rgba(0,0,0,0.1));">
                </div>
                <h3 style="font-size: 24px; margin: 0 0 10px 0; color: #2c3e50;">DNS Stack</h3>
                <p style="color: #6c757d; margin: 0 0 10px 0; font-size: 14px; font-weight: 600;">Indian Company</p>
                <p style="color: #495057; margin: 0 0 25px 0; font-size: 14px; line-height: 1.6;">
                    Perfect for businesses operating in India and looking for local support with global reach.
                </p>
                <div style="margin-bottom: 20px;">
                    <a href="https://dnsstack.com/contact-us/" target="_blank" class="button button-primary button-large" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; text-shadow: 0 1px 2px rgba(0,0,0,0.2); padding: 12px 30px; font-size: 16px; display: inline-block; text-decoration: none;">
                        Get Started with DNS Stack →
                    </a>
                </div>
                <div style="display: flex; flex-direction: column; gap: 8px; font-size: 13px; color: #6c757d;">
                    <a href="https://dnsstack.com/spider/" target="_blank" style="text-decoration: none; color: #667eea; transition: color 0.2s;">
                        Learn about SPIDER →
                    </a>
                    <a href="https://dnsstack.com/marlin/" target="_blank" style="text-decoration: none; color: #667eea; transition: color 0.2s;">
                        Learn about MARLIN →
                    </a>
                    <a href="https://dnsstack.com/rhino/" target="_blank" style="text-decoration: none; color: #667eea; transition: color 0.2s;">
                        Learn about RHINO →
                    </a>
                </div>
            </div>
            
            <!-- Techtonic Systems Card -->
            <div style="background: white; border: 2px solid #28a745; border-radius: 12px; padding: 40px; text-align: center; transition: all 0.3s ease; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
                <div style="width: 100px; height: 100px; margin: 0 auto 20px;">
                    <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-techtonic.png'); ?>" 
                         alt="Techtonic Systems" 
                         style="width: 100%; height: 100%; object-fit: contain; filter: drop-shadow(0 2px 8px rgba(0,0,0,0.1));">
                </div>
                <h3 style="font-size: 24px; margin: 0 0 10px 0; color: #2c3e50;">Techtonic Systems</h3>
                <p style="color: #6c757d; margin: 0 0 10px 0; font-size: 14px; font-weight: 600;">US Company</p>
                <p style="color: #495057; margin: 0 0 25px 0; font-size: 14px; line-height: 1.6;">
                    Ideal for US-based businesses seeking American infrastructure and seamless AWS integration.
                </p>
                <div style="margin-bottom: 20px;">
                    <a href="https://techtonic.systems/contact-us/" target="_blank" class="button button-primary button-large" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border: none; text-shadow: 0 1px 2px rgba(0,0,0,0.2); padding: 12px 30px; font-size: 16px; display: inline-block; text-decoration: none;">
                        Get Started with Techtonic →
                    </a>
                </div>
                <div style="display: flex; flex-direction: column; gap: 8px; font-size: 13px; color: #6c757d;">
                    <a href="https://aws.amazon.com/marketplace/pp/prodview-lxqmqbxtnruwg" target="_blank" style="text-decoration: none; color: #28a745; transition: color 0.2s;">
                        SPIDER on AWS Marketplace →
                    </a>
                    <a href="https://aws.amazon.com/marketplace/pp/prodview-s7vo2ycygb7ua" target="_blank" style="text-decoration: none; color: #28a745; transition: color 0.2s;">
                        MARLIN on AWS Marketplace →
                    </a>
                    <a href="https://aws.amazon.com/marketplace/pp/prodview-jpikopoo6fuza" target="_blank" style="text-decoration: none; color: #28a745; transition: color 0.2s;">
                        RHINO on AWS Marketplace →
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modules Section -->
    <div style="margin: 60px 0;">
        <h2 style="text-align: center; font-size: 36px; margin: 0 0 50px 0; color: #2c3e50;">
            Three Powerful Modules
        </h2>
        
        <!-- SPIDER Module -->
        <div style="background: white; border: 2px solid #f39c12; border-radius: 12px; padding: 40px; margin-bottom: 30px; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
            <div style="display: grid; grid-template-columns: 200px 1fr; gap: 40px; align-items: center;">
                <div style="text-align: center;">
                    <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-spider.png'); ?>" 
                         alt="SPIDER" 
                         style="max-width: 180px; height: auto; filter: drop-shadow(0 2px 8px rgba(0,0,0,0.1));">
                </div>
                <div>
                    <h3 style="font-size: 28px; margin: 0 0 15px 0; color: #f39c12;">
                        🕷️ SPIDER - AI-Powered Prerenderer
                    </h3>
                    <p style="font-size: 16px; color: #495057; line-height: 1.7; margin: 0 0 20px 0;">
                        The bridge between your JavaScript and search engines. SPIDER uses AI-powered prerendering to ensure search engines can fully crawl and index your JavaScript-heavy websites, dramatically improving your SEO performance.
                    </p>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                        <div style="background: #fff9e6; padding: 15px; border-radius: 8px; border-left: 4px solid #f39c12;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">✅ Better SEO</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Fully rendered HTML for faster indexing</p>
                        </div>
                        <div style="background: #fff9e6; padding: 15px; border-radius: 8px; border-left: 4px solid #f39c12;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">⚡ Faster Loads</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Prerendering speeds up page display</p>
                        </div>
                        <div style="background: #fff9e6; padding: 15px; border-radius: 8px; border-left: 4px solid #f39c12;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">🔧 Framework Friendly</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Works with React, Angular, Vue, Next.js</p>
                        </div>
                        <div style="background: #fff9e6; padding: 15px; border-radius: 8px; border-left: 4px solid #f39c12;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">📈 Lower Bounce Rates</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Faster pages keep visitors engaged</p>
                        </div>
                    </div>
                    
                    <div style="display: flex; gap: 15px;">
                        <a href="https://spider.utility-server.com/" target="_blank" class="button" style="text-decoration: none;">
                            📚 Documentation
                        </a>
                        <a href="https://dnsstack.com/spider-pricing/" target="_blank" class="button button-primary" style="background: #f39c12; border-color: #f39c12; text-decoration: none;">
                            View Pricing
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- MARLIN Module -->
        <div style="background: white; border: 2px solid #3498db; border-radius: 12px; padding: 40px; margin-bottom: 30px; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
            <div style="display: grid; grid-template-columns: 200px 1fr; gap: 40px; align-items: center;">
                <div style="text-align: center;">
                    <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-marlin.png'); ?>" 
                         alt="MARLIN" 
                         style="max-width: 180px; height: auto; filter: drop-shadow(0 2px 8px rgba(0,0,0,0.1));">
                </div>
                <div>
                    <h3 style="font-size: 28px; margin: 0 0 15px 0; color: #3498db;">
                        🐟 MARLIN - Intelligent Image Optimizer
                    </h3>
                    <p style="font-size: 16px; color: #495057; line-height: 1.7; margin: 0 0 20px 0;">
                        Your all-in-one solution for image optimization. MARLIN uses AI to automatically compress, resize, and convert images to modern formats like WebP and AVIF, reducing your CDN costs by up to 40% while maintaining exceptional visual quality.
                    </p>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                        <div style="background: #e3f2fd; padding: 15px; border-radius: 8px; border-left: 4px solid #3498db;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">🤖 AI Optimization</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Smart compression per device</p>
                        </div>
                        <div style="background: #e3f2fd; padding: 15px; border-radius: 8px; border-left: 4px solid #3498db;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">💰 Reduce CDN Costs</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Cut costs by up to 40%</p>
                        </div>
                        <div style="background: #e3f2fd; padding: 15px; border-radius: 8px; border-left: 4px solid #3498db;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">📐 Responsive Resize</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Perfect dimensions for any device</p>
                        </div>
                        <div style="background: #e3f2fd; padding: 15px; border-radius: 8px; border-left: 4px solid #3498db;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">🖼️ Modern Formats</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Auto WebP and AVIF conversion</p>
                        </div>
                    </div>
                    
                    <div style="display: flex; gap: 15px;">
                        <a href="https://marlin.utility-server.com/" target="_blank" class="button" style="text-decoration: none;">
                            📚 Documentation
                        </a>
                        <a href="https://dnsstack.com/marlin-pricing/" target="_blank" class="button button-primary" style="background: #3498db; border-color: #3498db; text-decoration: none;">
                            View Pricing
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- RHINO Module -->
        <div style="background: white; border: 2px solid #e74c3c; border-radius: 12px; padding: 40px; margin-bottom: 30px; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
            <div style="display: grid; grid-template-columns: 200px 1fr; gap: 40px; align-items: center;">
                <div style="text-align: center;">
                    <img src="<?php echo esc_url(CDN1_PLUGIN_URL . 'admin/images/logo-rhino.png'); ?>" 
                         alt="RHINO" 
                         style="max-width: 180px; height: auto; filter: drop-shadow(0 2px 8px rgba(0,0,0,0.1));">
                </div>
                <div>
                    <h3 style="font-size: 28px; margin: 0 0 15px 0; color: #e74c3c;">
                        🦏 RHINO - Edge Accelerator
                    </h3>
                    <p style="font-size: 16px; color: #495057; line-height: 1.7; margin: 0 0 20px 0;">
                        Dominate the edge. RHINO is an advanced edge caching solution that caches fully-rendered HTML at the edge for ultra-fast load times. Perfect companion to MARLIN, delivering peak performance for your entire web stack.
                    </p>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                        <div style="background: #ffebee; padding: 15px; border-radius: 8px; border-left: 4px solid #e74c3c;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">⚡ Lightning Fast</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Instant HTML delivery from memory</p>
                        </div>
                        <div style="background: #ffebee; padding: 15px; border-radius: 8px; border-left: 4px solid #e74c3c;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">🔄 Smart Invalidation</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Auto-update cached content</p>
                        </div>
                        <div style="background: #ffebee; padding: 15px; border-radius: 8px; border-left: 4px solid #e74c3c;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">🛡️ Failover Safety</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Automatic fallback to origin</p>
                        </div>
                        <div style="background: #ffebee; padding: 15px; border-radius: 8px; border-left: 4px solid #e74c3c;">
                            <h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 14px;">📊 Analytics Built-in</h4>
                            <p style="margin: 0; font-size: 13px; color: #6c757d;">Track cache hits, misses & performance</p>
                        </div>
                    </div>
                    
                    <div style="display: flex; gap: 15px;">
                        <a href="https://rhino.utility-server.com/" target="_blank" class="button" style="text-decoration: none;">
                            📚 Documentation
                        </a>
                        <a href="https://dnsstack.com/rhino-pricing/" target="_blank" class="button button-primary" style="background: #e74c3c; border-color: #e74c3c; text-decoration: none;">
                            View Pricing
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Benefits Section -->
    <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 50px 40px; border-radius: 12px; margin: 60px 0;">
        <h2 style="text-align: center; font-size: 32px; margin: 0 0 40px 0; color: #2c3e50;">
            Why Choose Utility Server?
        </h2>
        
        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 25px; max-width: 1000px; margin: 0 auto;">
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">🚀</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Peak Performance</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">Dramatically improve load times and user experience with AI-powered optimization</p>
            </div>
            
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">💰</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Cost Savings</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">Reduce CDN costs by up to 40% with intelligent image optimization</p>
            </div>
            
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">📈</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Better SEO</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">Ensure search engines can fully crawl and index your content</p>
            </div>
            
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">🔧</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Easy Integration</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">No-code setup with seamless WordPress and CMS integration</p>
            </div>
            
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">🌍</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Global Reach</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">Edge delivery network ensures fast performance worldwide</p>
            </div>
            
            <div style="background: white; padding: 25px; border-radius: 8px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                <div style="font-size: 48px; margin-bottom: 15px;">🛡️</div>
                <h4 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;">Enterprise Ready</h4>
                <p style="margin: 0; color: #6c757d; font-size: 14px; line-height: 1.6;">Built-in failover, monitoring, and 24/7 reliability</p>
            </div>
        </div>
    </div>
    
    <!-- CTA Section -->
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 50px 40px; border-radius: 12px; text-align: center; color: white; margin: 60px 0; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">
        <h2 style="font-size: 36px; margin: 0 0 20px 0; font-weight: 700; text-shadow: 0 2px 4px rgba(0,0,0,0.3);">
            Ready to Transform Your Website Performance?
        </h2>
        <p style="font-size: 18px; margin: 0 0 35px 0; opacity: 0.95; line-height: 1.6; max-width: 700px; margin-left: auto; margin-right: auto;">
            Join hundreds of businesses already using Utility Server to deliver faster, smarter, and more efficient web experiences.
        </p>
        
        <div style="display: flex; gap: 20px; justify-content: center; flex-wrap: wrap;">
            <a href="https://dnsstack.com/contact-us/" target="_blank" 
               style="background: white; color: #667eea; padding: 15px 40px; border-radius: 8px; text-decoration: none; font-size: 16px; font-weight: 600; display: inline-block; box-shadow: 0 4px 12px rgba(0,0,0,0.2); transition: all 0.3s ease;">
                Contact DNS Stack (India) →
            </a>
            <a href="https://techtonic.systems/contact-us/" target="_blank" 
               style="background: white; color: #28a745; padding: 15px 40px; border-radius: 8px; text-decoration: none; font-size: 16px; font-weight: 600; display: inline-block; box-shadow: 0 4px 12px rgba(0,0,0,0.2); transition: all 0.3s ease;">
                Contact Techtonic Systems (US) →
            </a>
        </div>
    </div>
    
    <!-- Footer Note -->
    <div style="text-align: center; color: #6c757d; font-size: 14px; margin: 40px 0 20px 0; padding-top: 30px; border-top: 1px solid #dee2e6;">
        <p style="margin: 0 0 10px 0;">
            <strong>Need Help Deciding?</strong>
        </p>
        <p style="margin: 0;">
            Both providers offer the same powerful Utility Server modules. Choose based on your location and preferred infrastructure.
        </p>
    </div>
</div>

<style>
.cdn1-pro-solution a.button:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(0,0,0,0.15);
}
</style>
