<?php
if (!defined('ABSPATH')) exit;

// Default CDN Settings
$enable_default_cdn = CDN1_Settings::get('enable_default_cdn', 0);
$enable_default_cdn_js = CDN1_Settings::get('enable_default_cdn_js', 0);
$enable_default_cdn_css = CDN1_Settings::get('enable_default_cdn_css', 0);
$enable_default_cdn_images = CDN1_Settings::get('enable_default_cdn_images', 0);
$enable_default_cdn_fonts = CDN1_Settings::get('enable_default_cdn_fonts', 0);
$enable_default_cdn_media = CDN1_Settings::get('enable_default_cdn_media', 0);

// Existing CDN Settings
$enable_origin_url = CDN1_Settings::get('enable_origin_url', 0);
$origin_url = CDN1_Settings::get('origin_url', '');
$enable_admin_url = CDN1_Settings::get('enable_admin_url', 0);
$admin_url = CDN1_Settings::get('admin_url', '');
$enable_image_cdn = CDN1_Settings::get('enable_image_cdn', 0);
$cdn_image_base = CDN1_Settings::get('cdn_image_base', '');
$enable_media_cdn = CDN1_Settings::get('enable_media_cdn', 0);
$cdn_media_base = CDN1_Settings::get('cdn_media_base', '');
$enable_css_cdn = CDN1_Settings::get('enable_css_cdn', 0);
$cdn_css_base = CDN1_Settings::get('cdn_css_base', '');
$enable_js_cdn = CDN1_Settings::get('enable_js_cdn', 0);
$cdn_js_base = CDN1_Settings::get('cdn_js_base', '');
$enable_static_cdn = CDN1_Settings::get('enable_static_cdn', 0);
$cdn_static_base = CDN1_Settings::get('cdn_static_base', '');
$enable_fonts_cdn = CDN1_Settings::get('enable_fonts_cdn', 0);
$cdn_fonts_base = CDN1_Settings::get('cdn_fonts_base', '');
$enable_frontend_url = CDN1_Settings::get('enable_frontend_url', 0);
$cdn_frontend_url = CDN1_Settings::get('cdn_frontend_url', '');
$cache_enabled = CDN1_Settings::get('cache_enabled', 1);
$custom_source_hosts = CDN1_Settings::get('custom_source_hosts', '');
$enable_dynamic_rewriting = CDN1_Settings::get('enable_dynamic_rewriting', 0);
$dynamic_rewriting_auto_rules = CDN1_Settings::get('dynamic_rewriting_auto_rules', 1);
$dynamic_rewriting_aggressive = CDN1_Settings::get('dynamic_rewriting_aggressive', 0);
$dynamic_rewrite_rules = CDN1_Settings::get('dynamic_rewrite_rules', '');
?>

<div class="wrap cdn1-settings">
    <?php include CDN1_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <p class="description">
        <?php esc_html_e('Configure your CDN settings for optimal performance. Manage Image CDN, Media CDN, Static CDN, Fonts CDN, and Frontend URL replacement.', '1cdn-manager'); ?>
    </p>
    
    <form method="post" action="" class="cdn1-form">
        <?php wp_nonce_field('cdn1_settings'); ?>
        
        <div class="cdn1-tabs">
            <button type="button" class="cdn1-tab active" data-tab="security" onclick="event.preventDefault();event.stopPropagation();document.querySelectorAll('.cdn1-tab:not(.cdn1-verify-tab)').forEach(t=>t.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.cdn1-tab-content').forEach(c=>c.classList.remove('active'));document.getElementById('security').classList.add('active');return false;"><?php esc_html_e('Registration', '1cdn-manager'); ?></button>
            <button type="button" class="cdn1-tab" data-tab="cdn-settings" onclick="event.preventDefault();event.stopPropagation();document.querySelectorAll('.cdn1-tab:not(.cdn1-verify-tab)').forEach(t=>t.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.cdn1-tab-content').forEach(c=>c.classList.remove('active'));document.getElementById('cdn-settings').classList.add('active');return false;"><?php esc_html_e('CDN Settings', '1cdn-manager'); ?></button>
            <button type="button" class="cdn1-tab" data-tab="content-rewriting" onclick="event.preventDefault();event.stopPropagation();document.querySelectorAll('.cdn1-tab:not(.cdn1-verify-tab)').forEach(t=>t.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.cdn1-tab-content').forEach(c=>c.classList.remove('active'));document.getElementById('content-rewriting').classList.add('active');return false;"><?php esc_html_e('Content Rewriting', '1cdn-manager'); ?></button>
            <button type="button" class="cdn1-tab" data-tab="advanced" onclick="event.preventDefault();event.stopPropagation();document.querySelectorAll('.cdn1-tab:not(.cdn1-verify-tab)').forEach(t=>t.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.cdn1-tab-content').forEach(c=>c.classList.remove('active'));document.getElementById('advanced').classList.add('active');return false;"><?php esc_html_e('Advanced', '1cdn-manager'); ?></button>
        </div>
        
        <!-- CDN Settings Tab -->
        <div class="cdn1-tab-content" id="cdn-settings">
            <h2><?php esc_html_e('CDN Configuration', '1cdn-manager'); ?></h2>
            
            <!-- Default CDN Section (Top Priority) -->
            <div class="cdn1-section" style="background: #e7f5ff; padding: 20px; border: 2px solid #1e88e5; border-radius: 5px; margin-bottom: 25px;">
                <h3 style="margin-top: 0; color: #1565c0;">
                    ⚡ <?php esc_html_e('Default CDN (1cdn.us)', '1cdn-manager'); ?>
                </h3>
                <p class="description" style="font-size: 14px; margin-bottom: 15px;">
                    <?php esc_html_e('Use preconfigured 1cdn.us subdomains for instant CDN setup. No configuration needed - just enable the asset types you want.', '1cdn-manager'); ?>
                </p>
                
                <div class="cdn1-notice" style="background: #fff3cd; padding: 12px; border-left: 4px solid #ff9800; margin-bottom: 15px;">
                    <strong>⚠️ <?php esc_html_e('Important:', '1cdn-manager'); ?></strong> 
                    <?php esc_html_e('When Default CDN is enabled, all custom CDN settings below will be automatically disabled.', '1cdn-manager'); ?>
                </div>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <strong><?php esc_html_e('Enable Default CDN', '1cdn-manager'); ?></strong>
                        </th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" id="enable_default_cdn" name="enable_default_cdn" value="1" <?php checked($enable_default_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                            <p class="description">
                                <?php esc_html_e('Master switch for Default CDN. Enable this to use preconfigured 1cdn.us subdomains.', '1cdn-manager'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
                
                <div id="default-cdn-options" style="<?php echo $enable_default_cdn ? '' : 'display:none;'; ?>">
                    <h4 style="margin-top: 20px;"><?php esc_html_e('Select Asset Types to Serve via Default CDN:', '1cdn-manager'); ?></h4>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <strong><?php esc_html_e('JavaScript', '1cdn-manager'); ?></strong>
                            </th>
                            <td>
                                <label class="cdn1-toggle">
                                    <input type="checkbox" name="enable_default_cdn_js" value="1" <?php checked($enable_default_cdn_js, 1); ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <strong><?php esc_html_e('CSS', '1cdn-manager'); ?></strong>
                            </th>
                            <td>
                                <label class="cdn1-toggle">
                                    <input type="checkbox" name="enable_default_cdn_css" value="1" <?php checked($enable_default_cdn_css, 1); ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <strong><?php esc_html_e('Images', '1cdn-manager'); ?></strong>
                            </th>
                            <td>
                                <label class="cdn1-toggle">
                                    <input type="checkbox" name="enable_default_cdn_images" value="1" <?php checked($enable_default_cdn_images, 1); ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <strong><?php esc_html_e('Fonts', '1cdn-manager'); ?></strong>
                            </th>
                            <td>
                                <label class="cdn1-toggle">
                                    <input type="checkbox" name="enable_default_cdn_fonts" value="1" <?php checked($enable_default_cdn_fonts, 1); ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <strong><?php esc_html_e('Media (Audio/Video)', '1cdn-manager'); ?></strong>
                            </th>
                            <td>
                                <label class="cdn1-toggle">
                                    <input type="checkbox" name="enable_default_cdn_media" value="1" <?php checked($enable_default_cdn_media, 1); ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                    </table>
                    
                    <?php
                    // Get registration info from Cloudflare KV
                    $registration_info = CDN1_Security::get_registration_info();
                    ?>
                    
                    <!-- Registration Status Display -->
                    <div id="cdn-registration-status" style="background: <?php echo $registration_info ? '#d4edda' : '#fff3cd'; ?>; padding: 15px; border-left: 4px solid <?php echo $registration_info ? '#28a745' : '#ffc107'; ?>; margin-top: 20px; border-radius: 4px;">
                        <h4 style="margin-top: 0; color: <?php echo $registration_info ? '#155724' : '#856404'; ?>;">
                            🔐 <?php esc_html_e('Domain Registration Status', '1cdn-manager'); ?>
                        </h4>
                        
                        <?php if ($registration_info && $registration_info['is_active']): ?>
                            <!-- Registered -->
                            <div style="margin-bottom: 10px;">
                                <strong style="color: #155724;">✅ <?php esc_html_e('Status:', '1cdn-manager'); ?></strong> 
                                <span style="color: #155724; font-weight: bold;"><?php esc_html_e('Registered', '1cdn-manager'); ?></span>
                            </div>
                            <div style="margin-bottom: 10px;">
                                <strong style="color: #155724;">🌐 <?php esc_html_e('Domain:', '1cdn-manager'); ?></strong> 
                                <code style="background: rgba(0,0,0,0.05); padding: 2px 6px; border-radius: 3px;"><?php echo esc_html($registration_info['domain']); ?></code>
                            </div>
                            <div style="margin-bottom: 10px;">
                                <strong style="color: #155724;">📅 <?php esc_html_e('Verified:', '1cdn-manager'); ?></strong> 
                                <?php echo esc_html($registration_info['verified_at']); ?>
                            </div>
                            <div style="margin-top: 12px;">
                                <p style="margin: 5px 0; font-size: 13px; color: #155724;">
                                    ✨ <?php esc_html_e('Unlimited CDN access with no rate limits!', '1cdn-manager'); ?>
                                </p>
                            </div>
                            <div style="background: #fff3cd; padding: 10px; border-left: 3px solid #ffc107; margin-top: 15px; border-radius: 4px;">
                                <p style="margin: 0; font-size: 13px; color: #856404;">
                                    <strong><?php esc_html_e('Note:', '1cdn-manager'); ?></strong> 
                                    <?php esc_html_e('We revalidate ownership periodically. Please make sure ownership records (meta tag, DNS record, or file) remain intact at all times.', '1cdn-manager'); ?>
                                </p>
                            </div>
                            <div style="margin-top: 15px;">
                                <button type="button" class="button button-secondary" id="cdn-check-ownership-btn" style="margin-right: 10px;">
                                    🔍 <?php esc_html_e('Check Ownership', '1cdn-manager'); ?>
                                </button>
                                <button type="button" class="button button-secondary" id="cdn-reregister-btn" style="background: #28a745; color: white; border: none;">
                                    🔄 <?php esc_html_e('Re-register Domain', '1cdn-manager'); ?>
                                </button>
                                <span class="spinner" id="cdn-action-spinner" style="float: none; margin: 0 10px; visibility: hidden;"></span>
                                <div id="cdn-ownership-result" style="margin-top: 10px;"></div>
                            </div>
                        <?php else: ?>
                            <!-- Not Registered -->
                            <div style="margin-bottom: 10px;">
                                <strong style="color: #856404;">⚠️ <?php esc_html_e('Status:', '1cdn-manager'); ?></strong> 
                                <span style="color: #856404; font-weight: bold;"><?php esc_html_e('Not Registered', '1cdn-manager'); ?></span>
                            </div>
                            <div style="margin-bottom: 10px;">
                                <strong style="color: #856404;">🌐 <?php esc_html_e('Domain:', '1cdn-manager'); ?></strong> 
                                <code style="background: rgba(0,0,0,0.05); padding: 2px 6px; border-radius: 3px;"><?php echo esc_html(CDN1_Security::get_master_domain()); ?></code>
                            </div>
                            <p style="margin: 10px 0; color: #856404;">
                                ⚡ <?php esc_html_e('Register your domain to unlock unlimited CDN access and remove rate limits.', '1cdn-manager'); ?>
                            </p>
                            <p style="margin: 10px 0; font-size: 13px; color: #856404;">
                                📝 <?php esc_html_e('Go to the', '1cdn-manager'); ?> <strong><?php esc_html_e('Security', '1cdn-manager'); ?></strong> <?php esc_html_e('tab to verify and register your domain.', '1cdn-manager'); ?>
                            </p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="cdn1-notice" style="background: #f0f6fc; padding: 15px; border-left: 4px solid #2196f3; margin-top: 15px;">
                        <h4 style="margin-top: 0;">✨ <?php esc_html_e('Benefits of Default CDN', '1cdn-manager'); ?></h4>
                        <ul style="margin-bottom: 0;">
                            <li>✅ <?php esc_html_e('No DNS configuration required', '1cdn-manager'); ?></li>
                            <li>✅ <?php esc_html_e('Instant setup - just enable and save', '1cdn-manager'); ?></li>
                            <li>✅ <?php esc_html_e('Preconfigured for optimal performance', '1cdn-manager'); ?></li>
                            <li>✅ <?php esc_html_e('All versioning features work normally', '1cdn-manager'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div id="custom-cdn-sections" style="<?php echo $enable_default_cdn ? 'opacity: 0.5; pointer-events: none;' : ''; ?>">
            
            <!-- Custom CDN Section with Frame -->
            <div style="border: 2px solid #ddd; border-radius: 8px; padding: 25px; margin-top: 30px; background: #fafafa;">
                <h2 style="margin-top: 0; margin-bottom: 10px; color: #2271b1;">
                    <?php esc_html_e('Custom CDN Configuration', '1cdn-manager'); ?>
                </h2>
                <p class="description" style="margin-bottom: 25px;">
                    <?php esc_html_e('Configure your own CDN domains for each asset type. Requires DNS setup and your own CDN service.', '1cdn-manager'); ?>
                </p>
            
            <!-- Domain Configuration -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('Domain Configuration', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Configure origin server and admin domain for advanced multi-domain setups.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Origin URL', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_origin_url" value="1" <?php checked($enable_origin_url, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Origin URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="origin_url" value="<?php echo esc_attr($origin_url); ?>" 
                                   class="regular-text" placeholder="https://origin.mydomain.com">
                            <p class="description">
                                <?php esc_html_e('The origin server URL where CDN pulls content from. Leave empty to use current site URL.', '1cdn-manager'); ?><br>
                                <strong><?php esc_html_e('Example:', '1cdn-manager'); ?></strong> https://origin.mydomain.com
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Admin URL', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_admin_url" value="1" <?php checked($enable_admin_url, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Admin URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="admin_url" value="<?php echo esc_attr($admin_url); ?>" 
                                   class="regular-text" placeholder="https://admin.mydomain.com">
                            <p class="description">
                                <?php esc_html_e('Separate admin panel domain (optional). Leave empty to use standard wp-admin.', '1cdn-manager'); ?><br>
                                <strong><?php esc_html_e('Example:', '1cdn-manager'); ?></strong> https://admin.mydomain.com
                            </p>
                        </td>
                    </tr>
                </table>
                
                <div class="cdn1-notice" style="background: #f0f6fc; padding: 15px; border-left: 4px solid #2271b1; margin-top: 15px;">
                    <h4 style="margin-top: 0;">💡 <?php esc_html_e('Multi-Domain Setup Example', '1cdn-manager'); ?></h4>
                    <ul style="margin-bottom: 0;">
                        <li><strong><?php esc_html_e('Public Website:', '1cdn-manager'); ?></strong> https://www.mydomain.com</li>
                        <li><strong><?php esc_html_e('Origin Server:', '1cdn-manager'); ?></strong> https://origin.mydomain.com</li>
                        <li><strong><?php esc_html_e('Image CDN:', '1cdn-manager'); ?></strong> https://img.mydomain.com</li>
                        <li><strong><?php esc_html_e('Static CDN:', '1cdn-manager'); ?></strong> https://static.mydomain.com</li>
                        <li><strong><?php esc_html_e('Admin Panel:', '1cdn-manager'); ?></strong> https://admin.mydomain.com</li>
                    </ul>
                </div>
                
                <div class="cdn1-notice" style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; margin-top: 15px;">
                    <h4 style="margin-top: 0;">⚠️ <?php esc_html_e('Important: Domain Redirect Prevention', '1cdn-manager'); ?></h4>
                    <p style="margin-bottom: 10px;">
                        <?php esc_html_e('Once you configure alternative domains above, the plugin automatically prevents WordPress from redirecting them back to the main site URL.', '1cdn-manager'); ?>
                    </p>
                    <p style="margin-bottom: 10px;">
                        <strong><?php esc_html_e('This means:', '1cdn-manager'); ?></strong>
                    </p>
                    <ul style="margin-bottom: 10px;">
                        <li>✓ <?php esc_html_e('You can access wp-admin via admin.mydomain.com without redirects', '1cdn-manager'); ?></li>
                        <li>✓ <?php esc_html_e('CDN domains will serve files without redirecting', '1cdn-manager'); ?></li>
                        <li>✓ <?php esc_html_e('Origin domain can be accessed directly', '1cdn-manager'); ?></li>
                    </ul>
                    <p style="margin-bottom: 0;">
                        <strong><?php esc_html_e('Check status:', '1cdn-manager'); ?></strong> <?php esc_html_e('Go to CDN Manager → Tools → Domain Mapping Status', '1cdn-manager'); ?>
                    </p>
                </div>
            </div>
            
            <!-- Image CDN -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('1. Image CDN', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Serve image files (.jpg, .png, .gif, .webp, .svg, etc.) from a dedicated CDN.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Image CDN', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_image_cdn" value="1" <?php checked($enable_image_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Image CDN Base URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_image_base" value="<?php echo esc_attr($cdn_image_base); ?>" 
                                   class="regular-text" placeholder="https://img.example.com">
                            <p class="description"><?php esc_html_e('Example: https://img.example.com', '1cdn-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Media CDN -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('2. Media CDN', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Serve video and audio files (.mp4, .webm, .mp3, .wav, etc.) from a dedicated CDN.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Media CDN', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_media_cdn" value="1" <?php checked($enable_media_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Media CDN Base URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_media_base" value="<?php echo esc_attr($cdn_media_base); ?>" 
                                   class="regular-text" placeholder="https://media.example.com">
                            <p class="description"><?php esc_html_e('Example: https://media.example.com', '1cdn-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- CSS CDN -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('3. CSS CDN', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Serve CSS stylesheets (.css) from a dedicated CDN.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable CSS CDN', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_css_cdn" value="1" <?php checked($enable_css_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('CSS CDN Base URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_css_base" value="<?php echo esc_attr($cdn_css_base); ?>" 
                                   class="regular-text" placeholder="https://css.example.com">
                            <p class="description"><?php esc_html_e('Example: https://css.example.com or https://cdn.example.com/css', '1cdn-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- JavaScript CDN -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('4. JavaScript CDN', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Serve JavaScript files (.js) from a dedicated CDN.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable JavaScript CDN', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_js_cdn" value="1" <?php checked($enable_js_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('JavaScript CDN Base URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_js_base" value="<?php echo esc_attr($cdn_js_base); ?>" 
                                   class="regular-text" placeholder="https://js.example.com">
                            <p class="description"><?php esc_html_e('Example: https://js.example.com or https://cdn.example.com/js', '1cdn-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Fonts CDN -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('5. Fonts CDN', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Serve font files and binary documents (.woff, .woff2, .ttf, .pdf, .zip, etc.) from a dedicated CDN.', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Fonts CDN', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_fonts_cdn" value="1" <?php checked($enable_fonts_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Fonts CDN Base URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_fonts_base" value="<?php echo esc_attr($cdn_fonts_base); ?>" 
                                   class="regular-text" placeholder="https://fonts.example.com">
                            <p class="description"><?php esc_html_e('Example: https://fonts.example.com', '1cdn-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Frontend URL -->
            <div class="cdn1-section">
                <h3><?php esc_html_e('6. Frontend URL (Domain Replacement)', '1cdn-manager'); ?></h3>
                <p class="description"><?php esc_html_e('Replace domain in all frontend links to keep browsing on a specific domain. This maintains consistent URLs across your site (e.g., ensure origin.mydomain.com opens as www.mydomain.com).', '1cdn-manager'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Frontend URL', '1cdn-manager'); ?></th>
                        <td>
                            <label class="cdn1-toggle">
                                <input type="checkbox" name="enable_frontend_url" value="1" <?php checked($enable_frontend_url, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Frontend URL', '1cdn-manager'); ?></th>
                        <td>
                            <input type="url" name="cdn_frontend_url" value="<?php echo esc_attr($cdn_frontend_url); ?>" 
                                   class="regular-text" placeholder="https://www.example.com">
                            <p class="description">
                                <?php esc_html_e('This replaces all page URLs with your preferred frontend domain. Not a CDN - it\'s a domain replacement service to maintain consistent browsing experience.', '1cdn-manager'); ?><br>
                                <strong><?php esc_html_e('Example:', '1cdn-manager'); ?></strong> https://www.example.com
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            </div><!-- End Custom CDN frame -->
            </div><!-- End custom-cdn-sections -->
        </div>
        
        <!-- Content Rewriting Tab -->
        <div class="cdn1-tab-content" id="content-rewriting">
            <h2><?php esc_html_e('Dynamic Content Rewriting', '1cdn-manager'); ?></h2>
            <p class="description"><?php esc_html_e('Rewrite URLs in saved content on-the-fly without modifying the database. Safe and reversible.', '1cdn-manager'); ?></p>
            
            <div class="notice notice-info inline">
                <p>
                    <strong>💡 <?php esc_html_e('Two Options Available:', '1cdn-manager'); ?></strong><br>
                    <strong><?php esc_html_e('On-the-Fly Rewriting (This Page):', '1cdn-manager'); ?></strong> <?php esc_html_e('Replaces URLs dynamically when content is displayed. No database changes.', '1cdn-manager'); ?><br>
                    <strong><?php esc_html_e('Content Migration:', '1cdn-manager'); ?></strong> <?php esc_html_e('Permanently updates URLs in database. Go to CDN Manager → Content Migration.', '1cdn-manager'); ?>
                </p>
            </div>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Dynamic Rewriting', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_dynamic_rewriting" value="1" <?php checked($enable_dynamic_rewriting, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php esc_html_e('Replace URLs in posts, pages, custom fields, and widgets on-the-fly without touching database.', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Auto-Generate Rules', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="dynamic_rewriting_auto_rules" value="1" <?php checked($dynamic_rewriting_auto_rules, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php esc_html_e('Automatically create rewrite rules based on your CDN configuration (Image CDN, Static CDN, Origin URL).', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Aggressive Mode', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="dynamic_rewriting_aggressive" value="1" <?php checked($dynamic_rewriting_aggressive, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php esc_html_e('Process entire HTML output (catch-all). More thorough but slightly slower. Only enable if standard mode misses some URLs.', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Custom Rewrite Rules', '1cdn-manager'); ?></th>
                    <td>
                        <textarea name="dynamic_rewrite_rules" rows="8" class="large-text code"><?php echo esc_textarea($dynamic_rewrite_rules); ?></textarea>
                        <p class="description">
                            <?php esc_html_e('Add custom find and replace rules. One per line in format:', '1cdn-manager'); ?><br>
                            <code>https://old-url.com | https://new-url.com</code><br>
                            <strong><?php esc_html_e('Example:', '1cdn-manager'); ?></strong><br>
                            <code>https://www.mydomain.com | https://origin.mydomain.com</code><br>
                            <code>https://www.mydomain.com/wp-content/uploads | https://img.mydomain.com/wp-content/uploads</code>
                        </p>
                    </td>
                </tr>
            </table>
            
            <div class="cdn1-section" style="background: #f0f6fc; padding: 20px; border-left: 4px solid #2271b1; margin-top: 20px;">
                <h3 style="margin-top: 0;"><?php esc_html_e('What Gets Rewritten?', '1cdn-manager'); ?></h3>
                <ul style="margin-bottom: 0;">
                    <li>✅ <?php esc_html_e('Post and page content', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('Excerpts and summaries', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('Custom fields (ACF, etc.)', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('Widgets and sidebars', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('WooCommerce descriptions', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('Page builder content (Elementor, Divi)', '1cdn-manager'); ?></li>
                    <li>✅ <?php esc_html_e('Site options (with aggressive mode)', '1cdn-manager'); ?></li>
                </ul>
            </div>
            
            <div class="cdn1-section" style="margin-top: 20px;">
                <h3><?php esc_html_e('On-the-Fly vs. Database Migration', '1cdn-manager'); ?></h3>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Feature', '1cdn-manager'); ?></th>
                            <th><?php esc_html_e('On-the-Fly (This Tab)', '1cdn-manager'); ?></th>
                            <th><?php esc_html_e('Database Migration', '1cdn-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><strong><?php esc_html_e('Database Changes', '1cdn-manager'); ?></strong></td>
                            <td><span style="color: green;">✓ None</span></td>
                            <td><span style="color: orange;">⚠ Permanent</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php esc_html_e('Reversible', '1cdn-manager'); ?></strong></td>
                            <td><span style="color: green;">✓ Yes (just disable)</span></td>
                            <td><span style="color: red;">✗ No (must migrate back)</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php esc_html_e('Performance', '1cdn-manager'); ?></strong></td>
                            <td><span style="color: orange;">Slightly slower</span></td>
                            <td><span style="color: green;">✓ Faster</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php esc_html_e('SEO Friendly', '1cdn-manager'); ?></strong></td>
                            <td><span style="color: orange;">Same URLs</span></td>
                            <td><span style="color: green;">✓ Permanent URLs</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php esc_html_e('Risk Level', '1cdn-manager'); ?></strong></td>
                            <td><span style="color: green;">✓ Very Safe</span></td>
                            <td><span style="color: orange;">⚠ Needs Backup</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php esc_html_e('Best For', '1cdn-manager'); ?></strong></td>
                            <td>Testing, temporary changes</td>
                            <td>Production, permanent changes</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Registration & Ownership Verification Tab -->
        <div class="cdn1-tab-content active" id="security">
            <h2><?php esc_html_e('Registration & Ownership Verification', '1cdn-manager'); ?></h2>
            
            <?php 
            // Get security status
            $security_status = CDN1_Security::get_status();
            ?>
            
            <p class="description">
                <?php esc_html_e('Verify your domain ownership to register with 1CDN and unlock unlimited CDN access with no rate limits.', '1cdn-manager'); ?>
            </p>
            <div class="notice notice-info inline" style="margin-top: 15px;">
                <p>
                    <strong><?php esc_html_e('How It Works:', '1cdn-manager'); ?></strong> 
                    <?php esc_html_e('Complete domain verification using one of the methods below, then register your domain. Registration lasts 7 days and can be renewed anytime.', '1cdn-manager'); ?>
                </p>
            </div>
                
            <div class="cdn1-section" style="background: #f0f9ff; padding: 20px; border: 2px solid #0ea5e9; border-radius: 5px; margin-top: 20px;">
                <?php if ($security_status['registered']): ?>
                        <!-- Registered Status -->
                        <div style="background: #d1fae5; padding: 15px; border-left: 4px solid #10b981; border-radius: 4px; margin-bottom: 15px;">
                            <p style="margin: 0; font-size: 16px;">
                                <strong>✅ <?php esc_html_e('Status: Registered', '1cdn-manager'); ?></strong>
                            </p>
                            <p style="margin: 10px 0 0 0; color: #047857;">
                                <?php esc_html_e('Your domain is verified and registered. You have unlimited CDN access with no rate limits.', '1cdn-manager'); ?>
                            </p>
                        </div>
                        
                        <?php 
                        $registration_info = isset($security_status['registration_info']) ? $security_status['registration_info'] : null;
                        ?>
                        
                        <table class="form-table">
                            <tr>
                                <th><?php esc_html_e('Domain:', '1cdn-manager'); ?></th>
                                <td><code><?php echo esc_html($security_status['domain']); ?></code></td>
                            </tr>
                            <?php if ($registration_info): ?>
                                <tr>
                                    <th><?php esc_html_e('Verification Method:', '1cdn-manager'); ?></th>
                                    <td>
                                        <?php 
                                        $method = isset($registration_info['verification_method']) ? $registration_info['verification_method'] : 'unknown';
                                        $method_labels = [
                                            'dns' => __('DNS TXT Record', '1cdn-manager'),
                                            'meta' => __('Meta Tag', '1cdn-manager'),
                                            'file' => __('File Upload', '1cdn-manager')
                                        ];
                                        echo esc_html($method_labels[$method] ?? ucfirst($method));
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('Verified At:', '1cdn-manager'); ?></th>
                                    <td><?php echo esc_html($registration_info['verified_at'] ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('Expires At:', '1cdn-manager'); ?></th>
                                    <td>
                                        <?php 
                                        echo esc_html($registration_info['expires_at'] ?? 'N/A'); 
                                        if (isset($registration_info['days_until_expiry'])) {
                                            echo ' (' . esc_html($registration_info['days_until_expiry']) . ' ' . __('days remaining', '1cdn-manager') . ')';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <?php if (isset($registration_info['expired']) && $registration_info['expired']): ?>
                                    <tr>
                                        <td colspan="2">
                                            <div class="notice notice-warning inline">
                                                <p><?php esc_html_e('⚠️ Your verification has expired. Please re-verify to maintain unlimited access.', '1cdn-manager'); ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php else: ?>
                                <tr>
                                    <th><?php esc_html_e('Registration Status:', '1cdn-manager'); ?></th>
                                    <td>
                                        <span style="color: #f59e0b;"><?php esc_html_e('⚠️ Unable to fetch registration details from Cloudflare. Domain may not be registered yet.', '1cdn-manager'); ?></span>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>
                        
                        <?php
                        // Check if Default CDN is enabled
                        $default_cdn_enabled = CDN1_Settings::get('enable_default_cdn', 0);
                        if ($default_cdn_enabled):
                        ?>
                        <div style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; border-radius: 4px; margin-top: 20px;">
                            <p style="margin: 0; color: #856404;">
                                <strong>⚠️ <?php esc_html_e('Warning:', '1cdn-manager'); ?></strong>
                                <?php esc_html_e('Revoking registration will automatically disable Default CDN and all its asset types (JS, CSS, Images, Fonts, Media). Your site will stop using 1cdn.us CDN immediately.', '1cdn-manager'); ?>
                            </p>
                        </div>
                        <?php endif; ?>
                        
                        <p style="margin-top: 20px;">
                            <button type="button" class="button" id="cdn1-revoke-key">
                                <?php esc_html_e('🗑️ Revoke Registration', '1cdn-manager'); ?>
                            </button>
                        </p>
                        
                    <?php else: ?>
                        <!-- Not Registered - Show Verification Options -->
                        <div style="background: #fef3c7; padding: 15px; border-left: 4px solid #f59e0b; border-radius: 4px; margin-bottom: 15px;">
                            <p style="margin: 0; font-size: 16px;">
                                <strong>⚠️ <?php esc_html_e('Status: Not Registered', '1cdn-manager'); ?></strong>
                            </p>
                            <p style="margin: 10px 0 0 0; color: #92400e;">
                                <?php esc_html_e('Register your domain to unlock unlimited CDN access and remove rate limits.', '1cdn-manager'); ?>
                            </p>
                        </div>
                        
                        <p class="description" style="margin-bottom: 30px;">
                            <?php esc_html_e('Choose one verification method below to prove you own this domain, then complete registration.', '1cdn-manager'); ?>
                        </p>
                        
                        <!-- Meta Tag Verification -->
                        <div style="background: #f0f9ff; padding: 20px; border: 2px solid #0ea5e9; border-radius: 5px; margin-bottom: 20px;">
                            <h3 style="margin-top: 0; color: #0369a1;">
                                🏷️ <?php esc_html_e('Method 1: Meta Tag Verification', '1cdn-manager'); ?>
                            </h3>
                            <p class="description" style="font-size: 14px; margin-bottom: 15px;">
                                <?php esc_html_e('✅ Easiest method for WordPress users - Add a meta tag to your site header.', '1cdn-manager'); ?>
                            </p>
                            
                            <table class="form-table">
                                <tr>
                                    <th><?php esc_html_e('Auto-Inject:', '1cdn-manager'); ?></th>
                                    <td>
                                        <button type="button" class="button button-primary" id="cdn1-auto-inject-meta">
                                            <?php esc_html_e('✨ Auto-Add Meta Tag', '1cdn-manager'); ?>
                                        </button>
                                        <p class="description"><?php esc_html_e('Plugin will automatically add the meta tag to your site\'s <head> section.', '1cdn-manager'); ?></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('Or Manual:', '1cdn-manager'); ?></th>
                                    <td>
                                        <code style="display: block; padding: 10px; background: #f5f5f5; word-break: break-all;">
                                            &lt;meta name="1cdn-verify" content="<?php echo esc_attr($security_status['verification_token']); ?>"&gt;
                                        </code>
                                        <p class="description"><?php esc_html_e('Copy and paste this into your theme\'s header.php file.', '1cdn-manager'); ?></p>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="margin-top: 20px;">
                                <button type="button" class="button button-primary cdn1-verify-btn" data-method="meta">
                                    <?php esc_html_e('🔍 Verify Meta Tag', '1cdn-manager'); ?>
                                </button>
                                <span class="cdn1-verify-result"></span>
                            </p>
                        </div>
                        
                        <!-- DNS Verification -->
                        <div style="background: #f0fdf4; padding: 20px; border: 2px solid #10b981; border-radius: 5px; margin-bottom: 20px;">
                            <h3 style="margin-top: 0; color: #047857;">
                                🌐 <?php esc_html_e('Method 2: DNS TXT Record Verification', '1cdn-manager'); ?>
                            </h3>
                            <p class="description" style="font-size: 14px; margin-bottom: 15px;">
                                <?php esc_html_e('🔒 Most secure method - Add a TXT record to your DNS settings.', '1cdn-manager'); ?>
                            </p>
                            
                            <table class="form-table">
                                <tr>
                                    <th><?php esc_html_e('Record Type:', '1cdn-manager'); ?></th>
                                    <td><code>TXT</code></td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('Host/Name:', '1cdn-manager'); ?></th>
                                    <td><code>_1cdn-verify.<?php echo esc_html($security_status['domain']); ?></code></td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('Value:', '1cdn-manager'); ?></th>
                                    <td>
                                        <code style="display: block; padding: 10px; background: #f5f5f5; word-break: break-all;">
                                            1cdn-verify=<?php echo esc_attr($security_status['verification_token']); ?>
                                        </code>
                                    </td>
                                </tr>
                            </table>
                            
                            <p class="description" style="margin-top: 15px;">
                                <?php esc_html_e('Add this TXT record to your DNS provider. Wait 5-10 minutes for propagation before verifying.', '1cdn-manager'); ?>
                            </p>
                            
                            <p style="margin-top: 20px;">
                                <button type="button" class="button button-primary cdn1-verify-btn" data-method="dns">
                                    <?php esc_html_e('🔍 Verify DNS Record', '1cdn-manager'); ?>
                                </button>
                                <span class="cdn1-verify-result"></span>
                            </p>
                        </div>
                        
                        <!-- File Verification -->
                        <div style="background: #fef3c7; padding: 20px; border: 2px solid #f59e0b; border-radius: 5px; margin-bottom: 20px;">
                            <h3 style="margin-top: 0; color: #92400e;">
                                📄 <?php esc_html_e('Method 3: Text File Verification', '1cdn-manager'); ?>
                            </h3>
                            <p class="description" style="font-size: 14px; margin-bottom: 15px;">
                                <?php esc_html_e('📁 Alternative method - Create a text file in your WordPress root directory.', '1cdn-manager'); ?>
                            </p>
                            
                            <table class="form-table">
                                <tr>
                                    <th><?php esc_html_e('File Name:', '1cdn-manager'); ?></th>
                                    <td><code>1cdn-verification.txt</code></td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('File Location:', '1cdn-manager'); ?></th>
                                    <td><code>https://<?php echo esc_html($security_status['domain']); ?>/1cdn-verification.txt</code></td>
                                </tr>
                                <tr>
                                    <th><?php esc_html_e('File Content:', '1cdn-manager'); ?></th>
                                    <td>
                                        <code style="display: block; padding: 10px; background: #f5f5f5; word-break: break-all;">
                                            <?php echo esc_attr($security_status['verification_token']); ?>
                                        </code>
                                    </td>
                                </tr>
                            </table>
                            
                            <p class="description" style="margin-top: 15px;">
                                <?php esc_html_e('Create this file in your WordPress root directory (same location as wp-config.php).', '1cdn-manager'); ?>
                            </p>
                            
                            <p style="margin-top: 20px;">
                                <button type="button" class="button button-primary cdn1-verify-btn" data-method="file">
                                    <?php esc_html_e('🔍 Verify File', '1cdn-manager'); ?>
                                </button>
                                <span class="cdn1-verify-result"></span>
                            </p>
                        </div>
                        
                        <!-- Registration Button -->
                        <div style="background: #dbeafe; padding: 15px; border-radius: 4px; margin-top: 20px;">
                            <p style="margin: 0 0 10px 0;">
                                <strong><?php esc_html_e('After verification is complete:', '1cdn-manager'); ?></strong>
                            </p>
                            <button type="button" class="button button-primary button-large" id="cdn1-complete-registration">
                                <?php esc_html_e('✅ Complete Registration', '1cdn-manager'); ?>
                            </button>
                            <span id="cdn1-registration-result" style="margin-left: 10px;"></span>
                        </div>
                        
                    <?php endif; ?>
                </div>
        </div>
        
        <!-- Advanced Tab -->
        <div class="cdn1-tab-content" id="advanced">
            <h2><?php esc_html_e('Advanced Settings', '1cdn-manager'); ?></h2>
            
            <h3><?php esc_html_e('CDN Versioning (Cache Busting)', '1cdn-manager'); ?></h3>
            <p class="description" style="margin-bottom: 20px;">
                <?php esc_html_e('Add version parameters to CDN URLs to force browsers to fetch updated assets. Configure each asset type independently for full control.', '1cdn-manager'); ?>
            </p>
            
            <table class="form-table">
                <!-- Image CDN Versioning -->
                <tr>
                    <th scope="row"><?php esc_html_e('Image Versioning', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_image_versioning" value="1" <?php checked(CDN1_Settings::get('enable_image_versioning'), 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <input type="text" name="image_version_string" value="<?php echo esc_attr(CDN1_Settings::get('image_version_string')); ?>" class="regular-text" placeholder="e.g., 1.0" style="margin-left: 10px;">
                        <p class="description"><?php esc_html_e('Version for Image CDN (.jpg, .png, .gif, .svg, .webp, .ico). Example: image.jpg?ver=1.0', '1cdn-manager'); ?></p>
                    </td>
                </tr>
                
                <!-- Media CDN Versioning -->
                <tr>
                    <th scope="row"><?php esc_html_e('Media Versioning', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_media_versioning" value="1" <?php checked(CDN1_Settings::get('enable_media_versioning'), 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <input type="text" name="media_version_string" value="<?php echo esc_attr(CDN1_Settings::get('media_version_string')); ?>" class="regular-text" placeholder="e.g., 1.0" style="margin-left: 10px;">
                        <p class="description"><?php esc_html_e('Version for Media CDN (.mp4, .mp3, .webm, .ogg, .avi). Example: video.mp4?ver=1.0', '1cdn-manager'); ?></p>
                    </td>
                </tr>
                
                <!-- CSS Versioning -->
                <tr>
                    <th scope="row"><?php esc_html_e('CSS Versioning', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_css_versioning" value="1" <?php checked(CDN1_Settings::get('enable_css_versioning'), 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <input type="text" name="css_version_string" value="<?php echo esc_attr(CDN1_Settings::get('css_version_string')); ?>" class="regular-text" placeholder="e.g., 1.0" style="margin-left: 10px;">
                        <p class="description"><?php esc_html_e('Version for CSS files on CSS CDN. Example: style.css?ver=1.0', '1cdn-manager'); ?></p>
                    </td>
                </tr>
                
                <!-- JavaScript Versioning -->
                <tr>
                    <th scope="row"><?php esc_html_e('JavaScript Versioning', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_js_versioning" value="1" <?php checked(CDN1_Settings::get('enable_js_versioning'), 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <input type="text" name="js_version_string" value="<?php echo esc_attr(CDN1_Settings::get('js_version_string')); ?>" class="regular-text" placeholder="e.g., 1.0" style="margin-left: 10px;">
                        <p class="description"><?php esc_html_e('Version for JavaScript files on JavaScript CDN. Example: script.js?ver=1.0', '1cdn-manager'); ?></p>
                    </td>
                </tr>
                
                <!-- Fonts CDN Versioning -->
                <tr>
                    <th scope="row"><?php esc_html_e('Fonts Versioning', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="enable_fonts_versioning" value="1" <?php checked(CDN1_Settings::get('enable_fonts_versioning'), 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <input type="text" name="fonts_version_string" value="<?php echo esc_attr(CDN1_Settings::get('fonts_version_string')); ?>" class="regular-text" placeholder="e.g., 1.0" style="margin-left: 10px;">
                        <p class="description"><?php esc_html_e('Version for Fonts CDN (.woff2, .woff, .ttf, .otf, .eot, .pdf, .zip). Example: font.woff2?ver=1.0', '1cdn-manager'); ?></p>
                    </td>
                </tr>
            </table>
            
            <hr style="margin: 30px 0;">
            <h3><?php esc_html_e('Cache & Performance Settings', '1cdn-manager'); ?></h3>
            <p class="description"><?php esc_html_e('These settings apply to both Default CDN and Custom CDN configurations.', '1cdn-manager'); ?></p>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Local CSS Caching', '1cdn-manager'); ?></th>
                    <td>
                        <label class="cdn1-toggle">
                            <input type="checkbox" name="cache_enabled" value="1" <?php checked($cache_enabled, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php esc_html_e('Cache rewritten CSS files locally for better performance. Works with both Default CDN and Custom CDN.', '1cdn-manager'); ?><br>
                            <strong><?php esc_html_e('Note:', '1cdn-manager'); ?></strong> <?php esc_html_e('Clear cache from Tools page after making changes.', '1cdn-manager'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Custom Source Hosts', '1cdn-manager'); ?></th>
                    <td>
                        <textarea name="custom_source_hosts" rows="4" class="large-text"><?php echo esc_textarea($custom_source_hosts); ?></textarea>
                        <p class="description"><?php esc_html_e('Add custom source hosts (one per line) for staging or alternative domains.', '1cdn-manager'); ?></p>
                    </td>
                </tr>
            </table>
        </div>
        
        <p class="submit">
            <button type="submit" name="cdn1_save_settings" class="button button-primary button-large">
                <?php esc_html_e('Save Settings', '1cdn-manager'); ?>
            </button>
        </p>
    </form>
</div>
