<?php
if (!defined('ABSPATH')) exit;

$validation = CDN1_Validator::validate_config();
?>

<div class="wrap cdn1-tools">
    <?php include CDN1_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <p class="description">
        <?php esc_html_e('Test your CDN configuration and manage cache.', '1cdn-manager'); ?>
    </p>
    
    <!-- Configuration Validation -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Configuration Status', '1cdn-manager'); ?></h2>
        
        <?php if ($validation['valid']): ?>
            <div class="notice notice-success inline">
                <p><strong><?php esc_html_e('✓ Configuration Valid', '1cdn-manager'); ?></strong></p>
                <p><?php esc_html_e('Your CDN configuration is properly set up.', '1cdn-manager'); ?></p>
            </div>
        <?php else: ?>
            <div class="notice notice-error inline">
                <p><strong><?php esc_html_e('⚠ Configuration Issues Found', '1cdn-manager'); ?></strong></p>
                <ul>
                    <?php foreach ($validation['errors'] as $error): ?>
                        <li><?php echo esc_html($error); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- CDN Testing Tool -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Test CDN Connections', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Verify that your CDN endpoints are accessible and working correctly.', '1cdn-manager'); ?></p>
        
        <div class="cdn1-test-tool">
            <?php if (CDN1_Settings::get('enable_image_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('Image CDN', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_image_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_image_base')); ?>" 
                            data-cdn-type="image">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_media_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('Media CDN', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_media_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_media_base')); ?>" 
                            data-cdn-type="media">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_css_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('CSS CDN', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_css_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_css_base')); ?>" 
                            data-cdn-type="css">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_js_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('JavaScript CDN', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_js_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_js_base')); ?>" 
                            data-cdn-type="js">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_static_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('Static CDN (Legacy)', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_static_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_static_base')); ?>" 
                            data-cdn-type="static">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_fonts_cdn')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('Fonts CDN', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_fonts_base')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_fonts_base')); ?>" 
                            data-cdn-type="fonts">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php if (CDN1_Settings::get('enable_frontend_url')): ?>
                <div class="cdn1-test-item">
                    <h3><?php esc_html_e('Frontend URL', '1cdn-manager'); ?></h3>
                    <p><code><?php echo esc_html(CDN1_Settings::get('cdn_frontend_url')); ?></code></p>
                    <button type="button" class="button cdn1-test-btn" 
                            data-cdn-url="<?php echo esc_attr(CDN1_Settings::get('cdn_frontend_url')); ?>" 
                            data-cdn-type="frontend">
                        <?php esc_html_e('Test Connection', '1cdn-manager'); ?>
                    </button>
                    <div class="cdn1-test-result"></div>
                </div>
            <?php endif; ?>
            
            <?php 
            $has_cdn = CDN1_Settings::get('enable_image_cdn') || 
                       CDN1_Settings::get('enable_media_cdn') || 
                       CDN1_Settings::get('enable_static_cdn') || 
                       CDN1_Settings::get('enable_fonts_cdn') || 
                       CDN1_Settings::get('enable_frontend_url');
            $is_default_cdn = CDN1_Settings::is_default_cdn_enabled();
            if (!$has_cdn): 
            ?>
                <div class="cdn1-empty-state">
                    <span class="dashicons dashicons-admin-tools"></span>
                    <?php if ($is_default_cdn): ?>
                        <p><?php esc_html_e('CDN testing is not required for Default CDN configuration.', '1cdn-manager'); ?></p>
                        <p><?php esc_html_e('This section works with Custom CDN solutions only.', '1cdn-manager'); ?></p>
                    <?php else: ?>
                        <p><?php esc_html_e('No Custom CDN configured yet. Enable at least one Custom CDN in settings to test.', '1cdn-manager'); ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Cache Management -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Local Cache Management', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Clear locally cached CSS files to force regeneration. Works with both Default CDN and Custom CDN.', '1cdn-manager'); ?></p>
        
        <div class="cdn1-cache-info">
            <?php
            $cache_dir = WP_CONTENT_DIR . '/cache/cdn1-css';
            $cache_files = [];
            if (is_dir($cache_dir)) {
                $cache_files = glob($cache_dir . '/*.css');
            }
            $cache_count = count($cache_files);
            $cache_size = 0;
            foreach ($cache_files as $file) {
                $cache_size += filesize($file);
            }
            $cache_size_mb = round($cache_size / 1024 / 1024, 2);
            ?>
            
            <div class="cdn1-cache-stats">
                <div class="stat">
                    <span class="dashicons dashicons-media-document"></span>
                    <strong><?php echo esc_html($cache_count); ?></strong> <?php esc_html_e('cached files', '1cdn-manager'); ?>
                </div>
                <div class="stat">
                    <span class="dashicons dashicons-database"></span>
                    <strong><?php echo esc_html($cache_size_mb); ?> MB</strong> <?php esc_html_e('cache size', '1cdn-manager'); ?>
                </div>
            </div>
            
            <p>
                <button type="button" class="button button-secondary cdn1-clear-cache-btn">
                    <?php esc_html_e('Clear All Cache', '1cdn-manager'); ?>
                </button>
                <span class="description"><?php esc_html_e('This will send the X-Cache-Flush: TRUE header to your CDN.', '1cdn-manager'); ?></span>
            </p>
        </div>
    </div>
    
    <!-- CDN Status Check -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('CDN Configuration Status', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Check which CDN types are currently enabled and configured.', '1cdn-manager'); ?></p>
        
        <?php
        // Run URL replacement test
        $test_url = home_url('/wp-content/uploads/2025/10/bg-video.mp4');
        $replacer = CDN1_Replacer::get_instance();
        $replaced_url = $replacer->replace_url($test_url);
        $test_passed = (strpos($replaced_url, 'media') !== false);
        ?>
        
        <?php if (!$test_passed && $replaced_url !== $test_url): ?>
        <div style="background: #dc3232; color: white; border-left: 4px solid #a00; padding: 12px; margin: 0 0 15px 0;">
            <p style="margin: 0; color: white;"><strong>🚨 CRITICAL ISSUE DETECTED:</strong></p>
            <p style="margin: 10px 0 0 0; color: white;">
                Test video URL is routing to <strong>WRONG CDN</strong>!<br>
                Expected: <code style="background: rgba(255,255,255,0.2); padding: 2px 6px; color: white;">...media...</code><br>
                Actual: <code style="background: rgba(255,255,255,0.2); padding: 2px 6px; color: white;"><?php echo esc_html($replaced_url); ?></code>
            </p>
        </div>
        <?php endif; ?>
        
        <table class="widefat" style="max-width: 800px;">
            <thead>
                <tr>
                    <th><?php esc_html_e('CDN Type', '1cdn-manager'); ?></th>
                    <th><?php esc_html_e('Status', '1cdn-manager'); ?></th>
                    <th><?php esc_html_e('URL', '1cdn-manager'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $is_default_cdn = CDN1_Settings::is_default_cdn_enabled();
                
                // If Default CDN is enabled, show Default CDN status
                if ($is_default_cdn) {
                    echo '<tr style="background: #e7f5ff;">';
                    echo '<td colspan="3"><strong style="color: #1565c0;">⚡ Default CDN Enabled (1cdn.us)</strong></td>';
                    echo '</tr>';
                    
                    $default_cdn_types = [
                        'js' => ['label' => 'JavaScript', 'subdomain' => 'js.1cdn.us', 'enable' => 'enable_default_cdn_js'],
                        'css' => ['label' => 'CSS', 'subdomain' => 'cs.1cdn.us', 'enable' => 'enable_default_cdn_css'],
                        'image' => ['label' => 'Images', 'subdomain' => 'im.1cdn.us', 'enable' => 'enable_default_cdn_images'],
                        'fonts' => ['label' => 'Fonts', 'subdomain' => 'ft.1cdn.us', 'enable' => 'enable_default_cdn_fonts'],
                        'media' => ['label' => 'Media', 'subdomain' => 'mi.1cdn.us', 'enable' => 'enable_default_cdn_media'],
                    ];
                    
                    foreach ($default_cdn_types as $key => $cdn) {
                        $enabled = CDN1_Settings::get($cdn['enable'], 0);
                        $status_color = $enabled ? 'green' : 'red';
                        $status_icon = $enabled ? '✓' : '✗';
                        $status_text = $enabled ? 'Enabled' : 'Disabled';
                        
                        echo '<tr>';
                        echo '<td><strong>' . esc_html($cdn['label']) . ' (Default CDN)</strong></td>';
                        echo '<td><span style="color: ' . esc_attr($status_color) . '; font-weight: bold;">' . esc_html($status_icon . ' ' . $status_text) . '</span></td>';
                        echo '<td>';
                        if ($enabled) {
                            echo '<code>' . esc_html($cdn['subdomain']) . '</code>';
                        } else {
                            echo '<span style="color: #999;">Not enabled</span>';
                        }
                        echo '</td>';
                        echo '</tr>';
                    }
                } else {
                    // Show custom CDN status
                    $cdn_types = [
                        'image' => ['label' => 'Image CDN', 'enable' => 'enable_image_cdn', 'url' => 'cdn_image_base'],
                        'media' => ['label' => 'Media CDN', 'enable' => 'enable_media_cdn', 'url' => 'cdn_media_base'],
                        'css' => ['label' => 'CSS CDN', 'enable' => 'enable_css_cdn', 'url' => 'cdn_css_base'],
                        'js' => ['label' => 'JavaScript CDN', 'enable' => 'enable_js_cdn', 'url' => 'cdn_js_base'],
                        'fonts' => ['label' => 'Fonts CDN', 'enable' => 'enable_fonts_cdn', 'url' => 'cdn_fonts_base'],
                        'frontend' => ['label' => 'Frontend URL', 'enable' => 'enable_frontend_url', 'url' => 'cdn_frontend_url'],
                    ];
                    
                    foreach ($cdn_types as $key => $cdn) {
                        $enabled = CDN1_Settings::get($cdn['enable'], 0);
                        $url = CDN1_Settings::get($cdn['url'], '');
                        $status_color = $enabled ? 'green' : 'red';
                        $status_icon = $enabled ? '✓' : '✗';
                        $status_text = $enabled ? 'Enabled' : 'Disabled';
                        
                        echo '<tr>';
                        echo '<td><strong>' . esc_html($cdn['label']) . '</strong></td>';
                        echo '<td><span style="color: ' . esc_attr($status_color) . '; font-weight: bold;">' . esc_html($status_icon . ' ' . $status_text) . '</span></td>';
                        echo '<td>';
                        if ($enabled && $url) {
                            echo '<code>' . esc_html($url) . '</code>';
                        } else {
                            echo '<span style="color: #999;">Not configured</span>';
                        }
                        echo '</td>';
                        echo '</tr>';
                    }
                }
                ?>
            </tbody>
        </table>
        
        <?php
        $is_default_cdn = CDN1_Settings::is_default_cdn_enabled();
        $media_enabled = CDN1_Settings::get('enable_media_cdn', 0);
        $fonts_enabled = CDN1_Settings::get('enable_fonts_cdn', 0);
        
        // Only show warnings if NOT using Default CDN
        if (!$is_default_cdn && (!$media_enabled || !$fonts_enabled)):
        ?>
        <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 15px 0;">
            <p style="margin: 0;"><strong>⚠️ Action Required:</strong></p>
            <ul style="margin: 10px 0 0 20px;">
                <?php if (!$media_enabled): ?>
                <li><strong>Media CDN is disabled!</strong> Videos are using Image CDN.</li>
                <?php endif; ?>
                <?php if (!$fonts_enabled): ?>
                <li><strong>Fonts CDN is disabled!</strong> Fonts may have CORS errors.</li>
                <?php endif; ?>
            </ul>
            <p style="margin: 10px 0 0 0;">
                <a href="<?php echo esc_url(admin_url('admin.php?page=cdn1-settings')); ?>" class="button button-primary">
                    Go to Settings →
                </a>
                
                <?php if (!$media_enabled): ?>
                <button type="button" class="button cdn1-quick-enable-btn" 
                        data-cdn-type="media" 
                        data-cdn-url="https://wpdemo-media.utility-server.com"
                        style="margin-left: 10px;">
                    <span class="dashicons dashicons-yes" style="margin-top: 3px;"></span>
                    Quick Enable Media CDN
                </button>
                <?php endif; ?>
                
                <?php if (!$fonts_enabled): ?>
                <button type="button" class="button cdn1-quick-enable-btn" 
                        data-cdn-type="fonts" 
                        data-cdn-url="https://wpdemo-fonts.utility-server.com"
                        style="margin-left: 10px;">
                    <span class="dashicons dashicons-yes" style="margin-top: 3px;"></span>
                    Quick Enable Fonts CDN
                </button>
                <?php endif; ?>
            </p>
            <div id="cdn1-quick-enable-result" style="margin-top: 10px;"></div>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- CDN URL Diagnostic Tool -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('CDN URL Diagnostic Tool', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Run comprehensive diagnostics to troubleshoot CDN URL routing issues.', '1cdn-manager'); ?></p>
        
        <div style="background: #e7f3ff; border-left: 4px solid #2271b1; padding: 12px; margin: 15px 0;">
            <p style="margin: 0;"><strong>ℹ️ What this tool does:</strong></p>
            <ul style="margin: 10px 0 0 20px;">
                <li>Checks database settings for all CDN types</li>
                <li>Tests URL replacement logic for different file types</li>
                <li>Identifies misconfigurations and routing issues</li>
                <li>Provides specific SQL fixes if needed</li>
            </ul>
        </div>
        
        <p>
            <button type="button" class="button button-primary" id="cdn1-run-diagnostics-btn">
                <span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
                <?php esc_html_e('Run Diagnostics', '1cdn-manager'); ?>
            </button>
        </p>
        
        <div id="cdn1-diagnostic-results" style="margin-top: 20px;"></div>
        
        <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#cdn1-run-diagnostics-btn').on('click', function(e) {
                e.preventDefault();
                
                var $btn = $(this);
                var $results = $('#cdn1-diagnostic-results');
                
                // Disable button and show loading
                $btn.prop('disabled', true);
                $btn.find('.dashicons').addClass('dashicons-update-spin');
                
                $results.html('<div class="notice notice-info inline" style="margin: 0;"><p>🔍 Running comprehensive diagnostics...</p></div>');
                
                // Make AJAX request
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'cdn1_run_diagnostics',
                        nonce: '<?php echo esc_js(wp_create_nonce('cdn1_run_diagnostics')); ?>'
                    },
                    success: function(response) {
                        if (response.success) {
                            $results.html(response.data.html);
                        } else {
                            $results.html(
                                '<div class="notice notice-error inline" style="margin: 0;">' +
                                '<p><strong>❌ Error:</strong> ' + response.data.message + '</p>' +
                                '</div>'
                            );
                        }
                    },
                    error: function() {
                        $results.html(
                            '<div class="notice notice-error inline" style="margin: 0;">' +
                            '<p><strong>❌ Error:</strong> Failed to run diagnostics. Please try again.</p>' +
                            '</div>'
                        );
                    },
                    complete: function() {
                        // Re-enable button and stop spinning
                        $btn.prop('disabled', false);
                        $btn.find('.dashicons').removeClass('dashicons-update-spin');
                    }
                });
            });
        });
        </script>
    </div>
    
    <!-- .htaccess Management -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('.htaccess Management', '1cdn-manager'); ?></h2>
        <p class="description"><?php esc_html_e('Regenerate .htaccess files with CORS headers for all CDN types (Image, Media, Static, Fonts).', '1cdn-manager'); ?></p>
        
        <div class="cdn1-htaccess-info">
            <?php
            $htaccess_path = WP_CONTENT_DIR . '/.htaccess';
            $htaccess_exists = file_exists($htaccess_path);
            $htaccess_size = $htaccess_exists ? filesize($htaccess_path) : 0;
            $htaccess_modified = $htaccess_exists ? gmdate('Y-m-d H:i:s', filemtime($htaccess_path)) : 'N/A';
            ?>
            
            <div class="cdn1-cache-stats">
                <div class="stat">
                    <span class="dashicons dashicons-media-document"></span>
                    <strong><?php echo $htaccess_exists ? 'Exists' : 'Not Found'; ?></strong> 
                    <?php echo $htaccess_exists ? '<span style="color: green;">✓</span>' : '<span style="color: red;">✗</span>'; ?>
                </div>
                <?php if ($htaccess_exists): ?>
                <div class="stat">
                    <span class="dashicons dashicons-clock"></span>
                    <strong><?php echo esc_html($htaccess_modified); ?></strong> <?php esc_html_e('last modified', '1cdn-manager'); ?>
                </div>
                <div class="stat">
                    <span class="dashicons dashicons-database"></span>
                    <strong><?php echo esc_html(size_format($htaccess_size)); ?></strong> <?php esc_html_e('file size', '1cdn-manager'); ?>
                </div>
                <?php endif; ?>
            </div>
            
            <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 15px 0;">
                <p style="margin: 0;"><strong>⚠️ When to use this:</strong></p>
                <ul style="margin: 10px 0 0 20px;">
                    <li>After upgrading from an older plugin version</li>
                    <li>If fonts or media files have CORS errors</li>
                    <li>If .htaccess was manually modified or deleted</li>
                    <li>After enabling new CDN types (Media CDN, Fonts CDN)</li>
                </ul>
            </div>
            
            <p>
                <button type="button" class="button button-primary cdn1-regenerate-htaccess-btn">
                    <span class="dashicons dashicons-update" style="margin-top: 3px;"></span>
                    <?php esc_html_e('Regenerate .htaccess Files', '1cdn-manager'); ?>
                </button>
                <span class="description"><?php esc_html_e('This will update wp-content/.htaccess with latest CORS rules for all 5 CDN types.', '1cdn-manager'); ?></span>
            </p>
            
            <div id="cdn1-htaccess-result" style="margin-top: 15px;"></div>
        </div>
    </div>
    
    
    <!-- System Information -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('System Information', '1cdn-manager'); ?></h2>
        
        <table class="widefat">
            <tbody>
                <tr>
                    <td><strong><?php esc_html_e('Plugin Version', '1cdn-manager'); ?></strong></td>
                    <td><?php echo esc_html(CDN1_VERSION); ?></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('WordPress Version', '1cdn-manager'); ?></strong></td>
                    <td><?php echo esc_html(get_bloginfo('version')); ?></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('PHP Version', '1cdn-manager'); ?></strong></td>
                    <td><?php echo PHP_VERSION; ?></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Site URL', '1cdn-manager'); ?></strong></td>
                    <td><?php echo esc_url(home_url()); ?></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Source Hosts', '1cdn-manager'); ?></strong></td>
                    <td><?php echo esc_html(implode(', ', CDN1_Settings::get_source_hosts())); ?></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Cache Directory', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php echo esc_html(WP_CONTENT_DIR . '/cache/cdn1-css'); ?>
                        <?php if (wp_is_writable($cache_dir)): ?>
                            <span class="dashicons dashicons-yes-alt" style="color: green;"></span> <?php esc_html_e('Writable', '1cdn-manager'); ?>
                        <?php else: ?>
                            <span class="dashicons dashicons-warning" style="color: red;"></span> <?php esc_html_e('Not writable', '1cdn-manager'); ?>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top: 15px;">
            <button type="button" class="button button-secondary" id="cdn1-check-updates-btn">
                <span class="dashicons dashicons-update" style="margin-top: 3px;"></span>
                <?php esc_html_e('Check for Updates', '1cdn-manager'); ?>
            </button>
            <span class="description"><?php esc_html_e('Force check for new plugin versions from S3', '1cdn-manager'); ?></span>
            <div id="cdn1-update-result" style="margin-top: 10px;"></div>
        </div>
        
        <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#cdn1-check-updates-btn').on('click', function(e) {
                e.preventDefault();
                
                var $btn = $(this);
                var $result = $('#cdn1-update-result');
                
                $btn.prop('disabled', true);
                $btn.find('.dashicons').addClass('dashicons-spin');
                $result.html('<div class="notice notice-info inline" style="margin: 0;"><p>🔍 Checking for updates...</p></div>');
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'cdn1_force_update_check',
                        nonce: '<?php echo esc_js(wp_create_nonce('cdn1_force_update_check')); ?>'
                    },
                    success: function(response) {
                        if (response.success) {
                            if (response.data.update_available) {
                                $result.html(
                                    '<div class="notice notice-warning inline" style="margin: 0;">' +
                                    '<p><strong>🎉 Update Available!</strong><br>' +
                                    'Current Version: <code>' + response.data.current_version + '</code><br>' +
                                    'Latest Version: <code>' + response.data.latest_version + '</code><br>' +
                                    '<a href="' + response.data.update_url + '" class="button button-primary" style="margin-top: 10px;">Update Now</a></p>' +
                                    '</div>'
                                );
                            } else {
                                $result.html(
                                    '<div class="notice notice-success inline" style="margin: 0;">' +
                                    '<p><strong>✓ You are using the latest version!</strong><br>' +
                                    'Current Version: <code>' + response.data.current_version + '</code></p>' +
                                    '</div>'
                                );
                            }
                        } else {
                            $result.html(
                                '<div class="notice notice-error inline" style="margin: 0;">' +
                                '<p><strong>❌ Error:</strong> ' + response.data.message + '</p>' +
                                '</div>'
                            );
                        }
                    },
                    error: function() {
                        $result.html(
                            '<div class="notice notice-error inline" style="margin: 0;">' +
                            '<p><strong>❌ Error:</strong> Failed to check for updates. Please try again.</p>' +
                            '</div>'
                        );
                    },
                    complete: function() {
                        $btn.prop('disabled', false);
                        $btn.find('.dashicons').removeClass('dashicons-spin');
                    }
                });
            });
        });
        </script>
    </div>
    
    <!-- Domain Mapping Status -->
    <div class="cdn1-section">
        <h2><?php esc_html_e('Domain Mapping Status', '1cdn-manager'); ?></h2>
        
        <?php $domain_info = CDN1_Domain_Mapper::get_domain_info(); ?>
        
        <table class="widefat">
            <tbody>
                <tr>
                    <td><strong><?php esc_html_e('Current Domain', '1cdn-manager'); ?></strong></td>
                    <td><code><?php echo esc_html($domain_info['current_host']); ?></code></td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Domain Type', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if ($domain_info['is_admin_domain']): ?>
                            <span style="color: #2271b1;"><strong><?php esc_html_e('Admin Domain', '1cdn-manager'); ?></strong></span>
                        <?php elseif ($domain_info['is_cdn_domain']): ?>
                            <span style="color: #00a32a;"><strong><?php esc_html_e('CDN Domain', '1cdn-manager'); ?></strong></span>
                        <?php else: ?>
                            <span><?php esc_html_e('Main Site Domain', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Redirect Prevention', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if ($domain_info['is_admin_domain'] || $domain_info['is_cdn_domain']): ?>
                            <span class="dashicons dashicons-yes-alt" style="color: green;"></span> <?php esc_html_e('Active', '1cdn-manager'); ?>
                        <?php else: ?>
                            <span class="dashicons dashicons-minus" style="color: gray;"></span> <?php esc_html_e('Not needed', '1cdn-manager'); ?>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Configured Admin URL', '1cdn-manager'); ?></strong></td>
                    <td>
                        <?php if ($domain_info['admin_url_configured']): ?>
                            <code><?php echo esc_html($domain_info['admin_url_configured']); ?></code>
                        <?php else: ?>
                            <span style="color: #999;"><?php esc_html_e('Not configured', '1cdn-manager'); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <?php if ($domain_info['is_admin_domain'] || $domain_info['is_cdn_domain']): ?>
        <div class="notice notice-success inline" style="margin-top: 15px;">
            <p>
                <strong>✓ <?php esc_html_e('Domain mapping is working!', '1cdn-manager'); ?></strong><br>
                <?php esc_html_e('You are accessing WordPress via an alternative domain and redirects are being prevented.', '1cdn-manager'); ?>
            </p>
        </div>
        <?php endif; ?>
    </div>
</div>
