<?php
/**
 * Uninstall Script
 * Cleanup when plugin is deleted
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove all plugin options
$options = [
    'cdn1_version',
    'cdn1_enable_image_cdn',
    'cdn1_cdn_image_base',
    'cdn1_enable_static_cdn',
    'cdn1_cdn_static_base',
    'cdn1_enable_link_cdn',
    'cdn1_cdn_link_base',
    'cdn1_setup_completed',
    'cdn1_analytics_enabled',
    'cdn1_cache_enabled',
    'cdn1_custom_source_hosts',
];

foreach ($options as $option) {
    delete_option($option);
}

// Remove analytics data
global $wpdb;
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'cdn1_analytics_%'"
);

// Remove cache directory
$cache_dir = WP_CONTENT_DIR . '/cache/uscdn-css';
if (is_dir($cache_dir)) {
    // Initialize WP_Filesystem
    global $wp_filesystem;
    if (empty($wp_filesystem)) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
        WP_Filesystem();
    }
    
    // Delete directory recursively
    $wp_filesystem->delete($cache_dir, true);
}

// Clear any transients
delete_transient('cdn1_cache_stats');
