# Privacy Policy

**Utility Server CDN Manager Plugin**  
**Last Updated:** October 12, 2025

---

## Our Privacy Commitment

**We DO NOT collect, store, or transmit any personal or private data to our servers.**

The Utility Server CDN Manager plugin operates entirely on your WordPress installation. All settings and credentials are stored locally in your WordPress database.

---

## 1. Information We Do NOT Collect

DNS Stack Private Limited (Utility Server) does **NOT** collect:

- ❌ Personal information (name, email, phone, address)
- ❌ Website URLs or domain names
- ❌ API keys or credentials (Cloudflare, CDN providers)
- ❌ CDN configuration settings
- ❌ Usage statistics or analytics
- ❌ User behavior or tracking data
- ❌ IP addresses or server information
- ❌ WordPress admin credentials
- ❌ Content or media files
- ❌ Any other private or sensitive data

## 2. Where Your Data is Stored

### 2.1 Local Storage Only

All plugin settings and credentials are stored exclusively in:
- **Your WordPress Database:** On your own server
- **Local File System:** Cache files in wp-content directory

### 2.2 No External Transmission

The plugin does NOT send any data to:
- ❌ Our servers (DNS Stack/Utility Server)
- ❌ Third-party analytics services
- ❌ External databases or APIs (except those you explicitly configure)

## 3. Third-Party Services

### 3.1 CDN Providers

If you configure CDN services (e.g., Cloudflare, AWS CloudFront), the plugin will:
- ✅ Send requests directly from YOUR server to YOUR CDN provider
- ✅ Use API credentials YOU provide
- ❌ Never send your credentials to our servers

### 3.2 Update Checks

The plugin checks for updates by:
- Downloading a JSON file from our AWS S3 bucket
- This is a one-way request (download only)
- No data about your site is sent to us

## 4. Cloudflare Integration

### 4.1 Optional Feature
Cloudflare integration is completely optional. You choose whether to enable it.

### 4.2 Direct Communication
When enabled, the plugin communicates directly between:
- **Your WordPress server** ↔ **Cloudflare API**
- We (DNS Stack) are NOT involved in this communication
- Cloudflare's privacy policy applies to their services

### 4.3 Credentials Security
Your Cloudflare credentials (Zone ID, API Token):
- ✅ Stored locally in your WordPress database
- ✅ Only accessible to WordPress administrators
- ❌ Never sent to our servers

## 5. Data Security

### 5.1 Your Responsibility
You are responsible for:
- Securing your WordPress installation
- Protecting your database credentials
- Safeguarding API keys and tokens
- Implementing proper server security

### 5.2 Our Commitment
We commit to:
- ✅ Not collecting your data
- ✅ Not transmitting your data to our servers
- ✅ Maintaining secure code practices
- ✅ Regular security updates

## 6. Cookies and Tracking

### 6.1 No Cookies
The plugin does NOT use cookies for tracking or analytics.

### 6.2 No Analytics
We do NOT track:
- Plugin usage statistics
- Feature usage
- Installation counts
- User behavior

## 7. Children's Privacy

Our plugin is not directed at children under 13. We do not knowingly collect data from children. Since we don't collect any data at all, this is not a concern.

## 8. International Users

Since all data is stored locally on YOUR server, data protection laws of YOUR jurisdiction apply. We do not transfer data internationally because we don't collect it.

## 9. Your Rights

Since we don't collect your data, typical privacy rights (access, deletion, portability) don't apply to us. However:
- ✅ You have full control over your local data
- ✅ You can delete the plugin and all its data anytime
- ✅ You control who accesses your WordPress admin

## 10. Data Retention

Plugin data is retained in your WordPress database until:
- You delete it manually
- You uninstall the plugin
- You delete your WordPress installation

We do not retain any of your data on our servers because we don't collect it.

## 11. Changes to This Policy

We may update this Privacy Policy from time to time. Changes will be posted on this page with an updated "Last Updated" date.

Material changes will be communicated through:
- Plugin update notes
- Our website

## 12. Contact Us

If you have questions about this Privacy Policy, please contact:

**DNS Stack Private Limited**  
Email: support@utility-server.com  
Website: https://www.utility-server.com

---

## Summary

**Bottom Line:** We don't collect, store, or transmit your data. Everything stays on your server. Your privacy is protected by default.

---

© 2025 DNS Stack Private Limited (Utility Server). All rights reserved.
