<?php
if (!defined('ABSPATH')) exit;

$summary = USCDN_Analytics::get_summary();
$analytics = USCDN_Analytics::get_analytics(7);
?>

<div class="wrap uscdn-analytics">
    <?php include USCDN_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <p class="description">
        <?php _e('Monitor your CDN performance and usage statistics.', 'utility-server-cdn'); ?>
    </p>
    
    <!-- Summary Cards -->
    <div class="uscdn-cards">
        <div class="uscdn-card">
            <div class="uscdn-card-icon">
                <span class="dashicons dashicons-images-alt2"></span>
            </div>
            <div class="uscdn-card-content">
                <h3><?php echo number_format($summary['image_replacements']); ?></h3>
                <p><?php _e('Image CDN Hits', 'utility-server-cdn'); ?></p>
            </div>
        </div>
        
        <div class="uscdn-card">
            <div class="uscdn-card-icon">
                <span class="dashicons dashicons-media-code"></span>
            </div>
            <div class="uscdn-card-content">
                <h3><?php echo number_format($summary['static_replacements']); ?></h3>
                <p><?php _e('Static CDN Hits', 'utility-server-cdn'); ?></p>
            </div>
        </div>
        
        <div class="uscdn-card">
            <div class="uscdn-card-icon">
                <span class="dashicons dashicons-admin-links"></span>
            </div>
            <div class="uscdn-card-content">
                <h3><?php echo number_format($summary['link_replacements']); ?></h3>
                <p><?php _e('Link CDN Hits', 'utility-server-cdn'); ?></p>
            </div>
        </div>
        
        <div class="uscdn-card">
            <div class="uscdn-card-icon">
                <span class="dashicons dashicons-update"></span>
            </div>
            <div class="uscdn-card-content">
                <h3><?php echo number_format($summary['total_replacements']); ?></h3>
                <p><?php _e('Total Replacements', 'utility-server-cdn'); ?></p>
            </div>
        </div>
    </div>
    
    <!-- Recent Activity -->
    <div class="uscdn-section">
        <h2><?php _e('Last 7 Days Activity', 'utility-server-cdn'); ?></h2>
        
        <?php if (!empty($analytics)): ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php _e('Date', 'utility-server-cdn'); ?></th>
                        <th><?php _e('Image CDN', 'utility-server-cdn'); ?></th>
                        <th><?php _e('Static CDN', 'utility-server-cdn'); ?></th>
                        <th><?php _e('Link CDN', 'utility-server-cdn'); ?></th>
                        <th><?php _e('Total', 'utility-server-cdn'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($analytics as $date => $stats): 
                        $total = array_sum($stats);
                    ?>
                    <tr>
                        <td><?php echo esc_html(date('F j, Y', strtotime($date))); ?></td>
                        <td><?php echo number_format($stats['image_replacements'] ?? 0); ?></td>
                        <td><?php echo number_format($stats['static_replacements'] ?? 0); ?></td>
                        <td><?php echo number_format($stats['link_replacements'] ?? 0); ?></td>
                        <td><strong><?php echo number_format($total); ?></strong></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="uscdn-empty-state">
                <span class="dashicons dashicons-chart-line"></span>
                <p><?php _e('No analytics data available yet. Data will appear as your CDN processes requests.', 'utility-server-cdn'); ?></p>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Performance Tips -->
    <div class="uscdn-section">
        <h2><?php _e('Performance Tips', 'utility-server-cdn'); ?></h2>
        <div class="uscdn-tips">
            <div class="uscdn-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><?php _e('Enable all three CDN types for maximum performance improvement.', 'utility-server-cdn'); ?></p>
            </div>
            <div class="uscdn-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><?php _e('Regularly clear CSS cache after making theme changes.', 'utility-server-cdn'); ?></p>
            </div>
            <div class="uscdn-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><?php _e('Use CDN providers with global edge locations for best results.', 'utility-server-cdn'); ?></p>
            </div>
            <div class="uscdn-tip">
                <span class="dashicons dashicons-yes-alt"></span>
                <p><?php _e('Test your CDN configuration regularly using the Tools page.', 'utility-server-cdn'); ?></p>
            </div>
        </div>
    </div>
</div>
