<?php
/**
 * Plugin Branding Header
 * Displays Utility Server logo with RHINO and MARLIN icons
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="uscdn-branding">
    <div class="uscdn-branding-logos">
        <a href="https://www.utility-server.com" target="_blank" rel="noopener">
            <img src="<?php echo esc_url(USCDN_PLUGIN_URL . 'admin/images/logo-utility-server.png'); ?>" 
                 alt="Utility Server" 
                 class="uscdn-branding-logo-main"
                 title="Visit Utility Server">
        </a>
        
        <div class="uscdn-branding-divider"></div>
        
        <div class="uscdn-branding-sub-logos">
            <a href="https://rhino.utility-server.com" target="_blank" rel="noopener">
                <img src="<?php echo esc_url(USCDN_PLUGIN_URL . 'admin/images/logo-rhino.png'); ?>" 
                     alt="RHINO" 
                     class="uscdn-branding-logo-sub"
                     title="RHINO Support - Advanced CDN Technology">
            </a>
            
            <a href="https://marlin.utility-server.com" target="_blank" rel="noopener">
                <img src="<?php echo esc_url(USCDN_PLUGIN_URL . 'admin/images/logo-marlin.png'); ?>" 
                     alt="MARLIN" 
                     class="uscdn-branding-logo-sub"
                     title="MARLIN Support - High-Speed Content Delivery">
            </a>
        </div>
    </div>
    
    <div class="uscdn-branding-info">
        <a href="https://wp-cdn-manager.utility-server.com" target="_blank" rel="noopener" style="text-decoration: none; color: inherit;">
            <h3 class="uscdn-branding-title">CDN Manager</h3>
            <p class="uscdn-branding-subtitle">Version <?php echo esc_html(USCDN_VERSION); ?></p>
        </a>
    </div>
</div>

<div class="uscdn-legal-notice" style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; padding: 12px 15px; margin: 15px 0; font-size: 13px;">
    <p style="margin: 0; color: #856404;">
        <strong>⚠️ Legal Notice:</strong> By using this plugin, you agree to our 
        <a href="https://wp-cdn-manager.utility-server.com/terms-and-conditions.html" target="_blank">Terms & Conditions</a>, 
        <a href="https://wp-cdn-manager.utility-server.com/license.html" target="_blank">License Agreement</a>, 
        <a href="https://wp-cdn-manager.utility-server.com/privacy-policy.html" target="_blank">Privacy Policy</a>, 
        <a href="https://wp-cdn-manager.utility-server.com/disclaimer.html" target="_blank">Disclaimer</a>, and 
        <a href="https://wp-cdn-manager.utility-server.com/nda.html" target="_blank">NDA</a>. 
        This is proprietary software for personal, non-commercial use only.
    </p>
</div>
