<?php
if (!defined('ABSPATH')) exit;

$enable_origin_url = USCDN_Settings::get('enable_origin_url', 0);
$origin_url = USCDN_Settings::get('origin_url', '');
$enable_admin_url = USCDN_Settings::get('enable_admin_url', 0);
$admin_url = USCDN_Settings::get('admin_url', '');
$enable_image_cdn = USCDN_Settings::get('enable_image_cdn', 0);
$cdn_image_base = USCDN_Settings::get('cdn_image_base', '');
$enable_static_cdn = USCDN_Settings::get('enable_static_cdn', 0);
$cdn_static_base = USCDN_Settings::get('cdn_static_base', '');
$enable_link_cdn = USCDN_Settings::get('enable_link_cdn', 0);
$cdn_link_base = USCDN_Settings::get('cdn_link_base', '');
$analytics_enabled = USCDN_Settings::get('analytics_enabled', 1);
$cache_enabled = USCDN_Settings::get('cache_enabled', 1);
$custom_source_hosts = USCDN_Settings::get('custom_source_hosts', '');
$enable_dynamic_rewriting = USCDN_Settings::get('enable_dynamic_rewriting', 0);
$dynamic_rewriting_auto_rules = USCDN_Settings::get('dynamic_rewriting_auto_rules', 1);
$dynamic_rewriting_aggressive = USCDN_Settings::get('dynamic_rewriting_aggressive', 0);
$dynamic_rewrite_rules = USCDN_Settings::get('dynamic_rewrite_rules', '');
?>

<div class="wrap uscdn-settings">
    <?php include USCDN_PLUGIN_DIR . 'admin/views/branding.php'; ?>
    
    <p class="description">
        <?php _e('Configure your CDN settings for optimal performance. Separate CDNs for images, static assets, and page links.', 'utility-server-cdn'); ?>
    </p>
    
    <form method="post" action="" class="uscdn-form">
        <?php wp_nonce_field('uscdn_settings'); ?>
        
        <div class="uscdn-tabs">
            <button type="button" class="uscdn-tab active" data-tab="cdn-settings"><?php _e('CDN Settings', 'utility-server-cdn'); ?></button>
            <button type="button" class="uscdn-tab" data-tab="content-rewriting"><?php _e('Content Rewriting', 'utility-server-cdn'); ?></button>
            <button type="button" class="uscdn-tab" data-tab="advanced"><?php _e('Advanced', 'utility-server-cdn'); ?></button>
        </div>
        
        <!-- CDN Settings Tab -->
        <div class="uscdn-tab-content active" id="cdn-settings">
            <h2><?php _e('CDN Configuration', 'utility-server-cdn'); ?></h2>
            
            <!-- Domain Configuration -->
            <div class="uscdn-section">
                <h3><?php _e('Domain Configuration', 'utility-server-cdn'); ?></h3>
                <p class="description"><?php _e('Configure origin server and admin domain for advanced multi-domain setups.', 'utility-server-cdn'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable Origin URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <label class="uscdn-toggle">
                                <input type="checkbox" name="enable_origin_url" value="1" <?php checked($enable_origin_url, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Origin URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <input type="url" name="origin_url" value="<?php echo esc_attr($origin_url); ?>" 
                                   class="regular-text" placeholder="https://origin.mydomain.com">
                            <p class="description">
                                <?php _e('The origin server URL where CDN pulls content from. Leave empty to use current site URL.', 'utility-server-cdn'); ?><br>
                                <strong><?php _e('Example:', 'utility-server-cdn'); ?></strong> https://origin.mydomain.com
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Enable Admin URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <label class="uscdn-toggle">
                                <input type="checkbox" name="enable_admin_url" value="1" <?php checked($enable_admin_url, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Admin URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <input type="url" name="admin_url" value="<?php echo esc_attr($admin_url); ?>" 
                                   class="regular-text" placeholder="https://admin.mydomain.com">
                            <p class="description">
                                <?php _e('Separate admin panel domain (optional). Leave empty to use standard wp-admin.', 'utility-server-cdn'); ?><br>
                                <strong><?php _e('Example:', 'utility-server-cdn'); ?></strong> https://admin.mydomain.com
                            </p>
                        </td>
                    </tr>
                </table>
                
                <div class="uscdn-notice" style="background: #f0f6fc; padding: 15px; border-left: 4px solid #2271b1; margin-top: 15px;">
                    <h4 style="margin-top: 0;">💡 <?php _e('Multi-Domain Setup Example', 'utility-server-cdn'); ?></h4>
                    <ul style="margin-bottom: 0;">
                        <li><strong><?php _e('Public Website:', 'utility-server-cdn'); ?></strong> https://www.mydomain.com</li>
                        <li><strong><?php _e('Origin Server:', 'utility-server-cdn'); ?></strong> https://origin.mydomain.com</li>
                        <li><strong><?php _e('Image CDN:', 'utility-server-cdn'); ?></strong> https://img.mydomain.com</li>
                        <li><strong><?php _e('Static CDN:', 'utility-server-cdn'); ?></strong> https://static.mydomain.com</li>
                        <li><strong><?php _e('Admin Panel:', 'utility-server-cdn'); ?></strong> https://admin.mydomain.com</li>
                    </ul>
                </div>
                
                <div class="uscdn-notice" style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; margin-top: 15px;">
                    <h4 style="margin-top: 0;">⚠️ <?php _e('Important: Domain Redirect Prevention', 'utility-server-cdn'); ?></h4>
                    <p style="margin-bottom: 10px;">
                        <?php _e('Once you configure alternative domains above, the plugin automatically prevents WordPress from redirecting them back to the main site URL.', 'utility-server-cdn'); ?>
                    </p>
                    <p style="margin-bottom: 10px;">
                        <strong><?php _e('This means:', 'utility-server-cdn'); ?></strong>
                    </p>
                    <ul style="margin-bottom: 10px;">
                        <li>✓ <?php _e('You can access wp-admin via admin.mydomain.com without redirects', 'utility-server-cdn'); ?></li>
                        <li>✓ <?php _e('CDN domains will serve files without redirecting', 'utility-server-cdn'); ?></li>
                        <li>✓ <?php _e('Origin domain can be accessed directly', 'utility-server-cdn'); ?></li>
                    </ul>
                    <p style="margin-bottom: 0;">
                        <strong><?php _e('Check status:', 'utility-server-cdn'); ?></strong> <?php _e('Go to CDN Manager → Tools → Domain Mapping Status', 'utility-server-cdn'); ?>
                    </p>
                </div>
            </div>
            
            <!-- Image CDN -->
            <div class="uscdn-section">
                <h3><?php _e('Image CDN', 'utility-server-cdn'); ?></h3>
                <p class="description"><?php _e('Serve images and media files from a dedicated CDN.', 'utility-server-cdn'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable Image CDN', 'utility-server-cdn'); ?></th>
                        <td>
                            <label class="uscdn-toggle">
                                <input type="checkbox" name="enable_image_cdn" value="1" <?php checked($enable_image_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Image CDN Base URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <input type="url" name="cdn_image_base" value="<?php echo esc_attr($cdn_image_base); ?>" 
                                   class="regular-text" placeholder="https://img.example.com">
                            <p class="description"><?php _e('Example: https://img.example.com', 'utility-server-cdn'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Static CDN -->
            <div class="uscdn-section">
                <h3><?php _e('Static Assets CDN', 'utility-server-cdn'); ?></h3>
                <p class="description"><?php _e('Serve CSS, JavaScript, and font files from a dedicated CDN.', 'utility-server-cdn'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable Static CDN', 'utility-server-cdn'); ?></th>
                        <td>
                            <label class="uscdn-toggle">
                                <input type="checkbox" name="enable_static_cdn" value="1" <?php checked($enable_static_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Static CDN Base URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <input type="url" name="cdn_static_base" value="<?php echo esc_attr($cdn_static_base); ?>" 
                                   class="regular-text" placeholder="https://static.example.com">
                            <p class="description"><?php _e('Example: https://static.example.com', 'utility-server-cdn'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Link CDN -->
            <div class="uscdn-section">
                <h3><?php _e('Link CDN (Optional)', 'utility-server-cdn'); ?></h3>
                <p class="description"><?php _e('Serve all website URLs from an alternative domain (advanced users only).', 'utility-server-cdn'); ?></p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable Link CDN', 'utility-server-cdn'); ?></th>
                        <td>
                            <label class="uscdn-toggle">
                                <input type="checkbox" name="enable_link_cdn" value="1" <?php checked($enable_link_cdn, 1); ?>>
                                <span class="slider"></span>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e('Link CDN Base URL', 'utility-server-cdn'); ?></th>
                        <td>
                            <input type="url" name="cdn_link_base" value="<?php echo esc_attr($cdn_link_base); ?>" 
                                   class="regular-text" placeholder="https://www.example.com">
                            <p class="description"><?php _e('Example: https://www.example.com', 'utility-server-cdn'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Content Rewriting Tab -->
        <div class="uscdn-tab-content" id="content-rewriting">
            <h2><?php _e('Dynamic Content Rewriting', 'utility-server-cdn'); ?></h2>
            <p class="description"><?php _e('Rewrite URLs in saved content on-the-fly without modifying the database. Safe and reversible.', 'utility-server-cdn'); ?></p>
            
            <div class="notice notice-info inline">
                <p>
                    <strong>💡 <?php _e('Two Options Available:', 'utility-server-cdn'); ?></strong><br>
                    <strong><?php _e('On-the-Fly Rewriting (This Page):', 'utility-server-cdn'); ?></strong> <?php _e('Replaces URLs dynamically when content is displayed. No database changes.', 'utility-server-cdn'); ?><br>
                    <strong><?php _e('Content Migration:', 'utility-server-cdn'); ?></strong> <?php _e('Permanently updates URLs in database. Go to CDN Manager → Content Migration.', 'utility-server-cdn'); ?>
                </p>
            </div>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><?php _e('Enable Dynamic Rewriting', 'utility-server-cdn'); ?></th>
                    <td>
                        <label class="uscdn-toggle">
                            <input type="checkbox" name="enable_dynamic_rewriting" value="1" <?php checked($enable_dynamic_rewriting, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php _e('Replace URLs in posts, pages, custom fields, and widgets on-the-fly without touching database.', 'utility-server-cdn'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Auto-Generate Rules', 'utility-server-cdn'); ?></th>
                    <td>
                        <label class="uscdn-toggle">
                            <input type="checkbox" name="dynamic_rewriting_auto_rules" value="1" <?php checked($dynamic_rewriting_auto_rules, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php _e('Automatically create rewrite rules based on your CDN configuration (Image CDN, Static CDN, Origin URL).', 'utility-server-cdn'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Aggressive Mode', 'utility-server-cdn'); ?></th>
                    <td>
                        <label class="uscdn-toggle">
                            <input type="checkbox" name="dynamic_rewriting_aggressive" value="1" <?php checked($dynamic_rewriting_aggressive, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description">
                            <?php _e('Process entire HTML output (catch-all). More thorough but slightly slower. Only enable if standard mode misses some URLs.', 'utility-server-cdn'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Custom Rewrite Rules', 'utility-server-cdn'); ?></th>
                    <td>
                        <textarea name="dynamic_rewrite_rules" rows="8" class="large-text code"><?php echo esc_textarea($dynamic_rewrite_rules); ?></textarea>
                        <p class="description">
                            <?php _e('Add custom find and replace rules. One per line in format:', 'utility-server-cdn'); ?><br>
                            <code>https://old-url.com | https://new-url.com</code><br>
                            <strong><?php _e('Example:', 'utility-server-cdn'); ?></strong><br>
                            <code>https://www.mydomain.com | https://origin.mydomain.com</code><br>
                            <code>https://www.mydomain.com/wp-content/uploads | https://img.mydomain.com/wp-content/uploads</code>
                        </p>
                    </td>
                </tr>
            </table>
            
            <div class="uscdn-section" style="background: #f0f6fc; padding: 20px; border-left: 4px solid #2271b1; margin-top: 20px;">
                <h3 style="margin-top: 0;"><?php _e('What Gets Rewritten?', 'utility-server-cdn'); ?></h3>
                <ul style="margin-bottom: 0;">
                    <li>✅ <?php _e('Post and page content', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('Excerpts and summaries', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('Custom fields (ACF, etc.)', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('Widgets and sidebars', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('WooCommerce descriptions', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('Page builder content (Elementor, Divi)', 'utility-server-cdn'); ?></li>
                    <li>✅ <?php _e('Site options (with aggressive mode)', 'utility-server-cdn'); ?></li>
                </ul>
            </div>
            
            <div class="uscdn-section" style="margin-top: 20px;">
                <h3><?php _e('On-the-Fly vs. Database Migration', 'utility-server-cdn'); ?></h3>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php _e('Feature', 'utility-server-cdn'); ?></th>
                            <th><?php _e('On-the-Fly (This Tab)', 'utility-server-cdn'); ?></th>
                            <th><?php _e('Database Migration', 'utility-server-cdn'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><strong><?php _e('Database Changes', 'utility-server-cdn'); ?></strong></td>
                            <td><span style="color: green;">✓ None</span></td>
                            <td><span style="color: orange;">⚠ Permanent</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php _e('Reversible', 'utility-server-cdn'); ?></strong></td>
                            <td><span style="color: green;">✓ Yes (just disable)</span></td>
                            <td><span style="color: red;">✗ No (must migrate back)</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php _e('Performance', 'utility-server-cdn'); ?></strong></td>
                            <td><span style="color: orange;">Slightly slower</span></td>
                            <td><span style="color: green;">✓ Faster</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php _e('SEO Friendly', 'utility-server-cdn'); ?></strong></td>
                            <td><span style="color: orange;">Same URLs</span></td>
                            <td><span style="color: green;">✓ Permanent URLs</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php _e('Risk Level', 'utility-server-cdn'); ?></strong></td>
                            <td><span style="color: green;">✓ Very Safe</span></td>
                            <td><span style="color: orange;">⚠ Needs Backup</span></td>
                        </tr>
                        <tr>
                            <td><strong><?php _e('Best For', 'utility-server-cdn'); ?></strong></td>
                            <td>Testing, temporary changes</td>
                            <td>Production, permanent changes</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Advanced Tab -->
        <div class="uscdn-tab-content" id="advanced">
            <h2><?php _e('Advanced Settings', 'utility-server-cdn'); ?></h2>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><?php _e('Enable Analytics', 'utility-server-cdn'); ?></th>
                    <td>
                        <label class="uscdn-toggle">
                            <input type="checkbox" name="analytics_enabled" value="1" <?php checked($analytics_enabled, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description"><?php _e('Track CDN usage and performance metrics.', 'utility-server-cdn'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Enable CSS Caching', 'utility-server-cdn'); ?></th>
                    <td>
                        <label class="uscdn-toggle">
                            <input type="checkbox" name="cache_enabled" value="1" <?php checked($cache_enabled, 1); ?>>
                            <span class="slider"></span>
                        </label>
                        <p class="description"><?php _e('Cache rewritten CSS files for better performance.', 'utility-server-cdn'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php _e('Custom Source Hosts', 'utility-server-cdn'); ?></th>
                    <td>
                        <textarea name="custom_source_hosts" rows="4" class="large-text"><?php echo esc_textarea($custom_source_hosts); ?></textarea>
                        <p class="description"><?php _e('Add custom source hosts (one per line) for staging or alternative domains.', 'utility-server-cdn'); ?></p>
                    </td>
                </tr>
            </table>
        </div>
        
        <p class="submit">
            <button type="submit" name="uscdn_save_settings" class="button button-primary button-large">
                <?php _e('Save Settings', 'utility-server-cdn'); ?>
            </button>
        </p>
    </form>
</div>
