<?php
/**
 * Uninstall Script
 * Cleanup when plugin is deleted
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove all plugin options
$options = [
    'uscdn_version',
    'uscdn_enable_image_cdn',
    'uscdn_cdn_image_base',
    'uscdn_enable_static_cdn',
    'uscdn_cdn_static_base',
    'uscdn_enable_link_cdn',
    'uscdn_cdn_link_base',
    'uscdn_setup_completed',
    'uscdn_analytics_enabled',
    'uscdn_cache_enabled',
    'uscdn_custom_source_hosts',
];

foreach ($options as $option) {
    delete_option($option);
}

// Remove analytics data
global $wpdb;
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'uscdn_analytics_%'"
);

// Remove cache directory
$cache_dir = WP_CONTENT_DIR . '/cache/uscdn-css';
if (is_dir($cache_dir)) {
    $files = glob($cache_dir . '/*');
    if ($files) {
        foreach ($files as $file) {
            if (is_file($file)) {
                @unlink($file);
            }
        }
    }
    @rmdir($cache_dir);
}

// Clear any transients
delete_transient('uscdn_cache_stats');
